/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import org.orekit.estimation.measurements.EstimatedMeasurementBase;
import org.orekit.estimation.measurements.GroundReceiverMeasurement;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.modifiers.PhaseCentersOffsetComputer;
import org.orekit.frames.Frame;
import org.orekit.frames.Transform;
import org.orekit.gnss.antenna.FrequencyPattern;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.TimeStampedPVCoordinates;

public class PhaseCentersGroundReceiverBaseModifier<T extends GroundReceiverMeasurement<T>> {
    private final PhaseCentersOffsetComputer uplink;
    private final PhaseCentersOffsetComputer downlink;

    public PhaseCentersGroundReceiverBaseModifier(FrequencyPattern stationPattern, FrequencyPattern satellitePattern) {
        this.uplink = new PhaseCentersOffsetComputer(stationPattern, satellitePattern);
        this.downlink = new PhaseCentersOffsetComputer(satellitePattern, stationPattern);
    }

    public double oneWayDistanceModification(EstimatedMeasurementBase<T> estimated) {
        TimeStampedPVCoordinates[] participants = estimated.getParticipants();
        Frame inertial = estimated.getStates()[0].getFrame();
        GroundStation station = ((GroundReceiverMeasurement)estimated.getObservedMeasurement()).getStation();
        AbsoluteDate receptionDate = participants[1].getDate();
        Transform stationToInert = station.getOffsetToInertial(inertial, receptionDate, false);
        AbsoluteDate emissionDate = participants[0].getDate();
        SpacecraftState refState = estimated.getStates()[0];
        SpacecraftState emissionState = refState.shiftedBy(emissionDate.durationFrom(refState.getDate()));
        Transform spacecraftToInert = emissionState.toTransform().getInverse();
        return this.downlink.offset(spacecraftToInert, stationToInert);
    }

    public double twoWayDistanceModification(EstimatedMeasurementBase<T> estimated) {
        TimeStampedPVCoordinates[] participants = estimated.getParticipants();
        Frame inertial = estimated.getStates()[0].getFrame();
        GroundStation station = ((GroundReceiverMeasurement)estimated.getObservedMeasurement()).getStation();
        AbsoluteDate receptionDate = participants[2].getDate();
        Transform stationToInertReception = station.getOffsetToInertial(inertial, receptionDate, false);
        AbsoluteDate transitDate = participants[1].getDate();
        SpacecraftState refState = estimated.getStates()[0];
        SpacecraftState transitState = refState.shiftedBy(transitDate.durationFrom(refState.getDate()));
        Transform spacecraftToInert = transitState.toTransform().getInverse();
        AbsoluteDate emissionDate = participants[0].getDate();
        Transform stationToInertEmission = station.getOffsetToInertial(inertial, emissionDate, true);
        double uplinkOffset = this.uplink.offset(stationToInertEmission, spacecraftToInert);
        double downlinkOffset = this.downlink.offset(spacecraftToInert, stationToInertReception);
        return 0.5 * (uplinkOffset + downlinkOffset);
    }
}

