/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.Collections;
import java.util.List;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.estimation.measurements.EstimatedMeasurementBase;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.InterSatellitesRange;
import org.orekit.estimation.measurements.modifiers.PhaseCentersInterSatellitesBaseModifier;
import org.orekit.gnss.antenna.FrequencyPattern;
import org.orekit.utils.ParameterDriver;

public class OnBoardAntennaInterSatellitesRangeModifier
extends PhaseCentersInterSatellitesBaseModifier<InterSatellitesRange>
implements EstimationModifier<InterSatellitesRange> {
    public OnBoardAntennaInterSatellitesRangeModifier(Vector3D receiverPhaseCenter, Vector3D emitterPhaseCenter) {
        this(new FrequencyPattern(receiverPhaseCenter, null), new FrequencyPattern(emitterPhaseCenter, null));
    }

    public OnBoardAntennaInterSatellitesRangeModifier(FrequencyPattern receiverPattern, FrequencyPattern emitterPattern) {
        super(receiverPattern, emitterPattern);
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    @Override
    public void modifyWithoutDerivatives(EstimatedMeasurementBase<InterSatellitesRange> estimated) {
        double delta = estimated.getParticipants().length < 3 ? this.oneWayDistanceModification(estimated) : this.twoWayDistanceModification(estimated);
        estimated.modifyEstimatedValue(this, estimated.getEstimatedValue()[0] + delta);
    }
}

