/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurementBase;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeSpanMap;

public class Bias<T extends ObservedMeasurement<T>>
implements EstimationModifier<T> {
    private final List<ParameterDriver> drivers;
    private final double[][] derivatives;

    public Bias(String[] name, double[] bias, double[] scale, double[] min, double[] max) {
        int i;
        this.drivers = new ArrayList<ParameterDriver>(bias.length);
        for (i = 0; i < bias.length; ++i) {
            this.drivers.add(new ParameterDriver(name[i], bias[i], scale[i], min[i], max[i]));
        }
        this.derivatives = new double[bias.length][bias.length];
        for (i = 0; i < bias.length; ++i) {
            this.derivatives[i][i] = 1.0;
        }
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.unmodifiableList(this.drivers);
    }

    @Override
    public void modifyWithoutDerivatives(EstimatedMeasurementBase<T> estimated) {
        double[] value = estimated.getEstimatedValue();
        int nb = 0;
        for (ParameterDriver driver : this.drivers) {
            for (TimeSpanMap.Span<String> span = driver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                int n = nb++;
                value[n] = value[n] + driver.getValue(span.getStart());
            }
        }
        estimated.modifyEstimatedValue(this, value);
    }

    @Override
    public void modify(EstimatedMeasurement<T> estimated) {
        int nb = 0;
        for (ParameterDriver driver : this.drivers) {
            for (TimeSpanMap.Span<String> span = driver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                if (!driver.isSelected()) continue;
                estimated.setParameterDerivatives(driver, span.getStart(), this.derivatives[nb++]);
            }
        }
        this.modifyWithoutDerivatives(estimated);
    }
}

