/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.models.earth.troposphere.DiscreteTroposphericModel;
import org.orekit.models.earth.troposphere.TroposphericModel;
import org.orekit.models.earth.troposphere.TroposphericModelAdapter;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.utils.FieldTrackingCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TrackingCoordinates;

public abstract class BaseRangeTroposphericDelayModifier {
    private final TroposphericModel tropoModel;

    @Deprecated
    protected BaseRangeTroposphericDelayModifier(DiscreteTroposphericModel model) {
        this(new TroposphericModelAdapter(model));
    }

    protected BaseRangeTroposphericDelayModifier(TroposphericModel model) {
        this.tropoModel = model;
    }

    protected TroposphericModel getTropoModel() {
        return this.tropoModel;
    }

    public double rangeErrorTroposphericModel(GroundStation station, SpacecraftState state) {
        Vector3D position = state.getPosition();
        TrackingCoordinates trackingCoordinates = station.getBaseFrame().getTrackingCoordinates(position, state.getFrame(), state.getDate());
        if (trackingCoordinates.getElevation() > 0.0) {
            double delay = this.tropoModel.pathDelay(trackingCoordinates, station.getOffsetGeodeticPoint(state.getDate()), station.getPressureTemperatureHumidity(state.getDate()), this.tropoModel.getParameters(), state.getDate()).getDelay();
            return delay;
        }
        return 0.0;
    }

    public <T extends CalculusFieldElement<T>> T rangeErrorTroposphericModel(GroundStation station, FieldSpacecraftState<T> state, T[] parameters) {
        Field<T> field = state.getDate().getField();
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        FieldVector3D<T> position = state.getPosition();
        FieldTrackingCoordinates<T> trackingCoordinates = station.getBaseFrame().getTrackingCoordinates(position, state.getFrame(), state.getDate());
        if (trackingCoordinates.getElevation().getReal() > 0.0) {
            Object delay = this.tropoModel.pathDelay(trackingCoordinates, station.getOffsetGeodeticPoint(state.getDate()), station.getPressureTemperatureHumidity(state.getDate()), (CalculusFieldElement[])parameters, state.getDate()).getDelay();
            return delay;
        }
        return (T)zero;
    }

    public List<ParameterDriver> getParametersDrivers() {
        return this.tropoModel.getParametersDrivers();
    }
}

