/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.models.earth.troposphere.DiscreteTroposphericModel;
import org.orekit.models.earth.troposphere.TroposphericModel;
import org.orekit.models.earth.troposphere.TroposphericModelAdapter;
import org.orekit.propagation.FieldSpacecraftState;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.TimeShiftable;
import org.orekit.utils.FieldTrackingCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TrackingCoordinates;

public abstract class BaseRangeRateTroposphericDelayModifier {
    private final TroposphericModel tropoModel;

    @Deprecated
    protected BaseRangeRateTroposphericDelayModifier(DiscreteTroposphericModel model) {
        this(new TroposphericModelAdapter(model));
    }

    protected BaseRangeRateTroposphericDelayModifier(TroposphericModel model) {
        this.tropoModel = model;
    }

    protected TroposphericModel getTropoModel() {
        return this.tropoModel;
    }

    public double rangeRateErrorTroposphericModel(GroundStation station, SpacecraftState state) {
        double dt = 10.0;
        Vector3D position = state.getPosition();
        TrackingCoordinates trackingCoordinates1 = station.getBaseFrame().getTrackingCoordinates(position, state.getFrame(), state.getDate());
        if (trackingCoordinates1.getElevation() > 0.0) {
            double d1 = this.tropoModel.pathDelay(trackingCoordinates1, station.getOffsetGeodeticPoint(state.getDate()), station.getPressureTemperatureHumidity(state.getDate()), this.tropoModel.getParameters(state.getDate()), state.getDate()).getDelay();
            SpacecraftState state2 = state.shiftedBy(10.0);
            Vector3D position2 = state2.getPosition();
            TrackingCoordinates trackingCoordinates2 = station.getBaseFrame().getTrackingCoordinates(position2, state2.getFrame(), state2.getDate());
            double d2 = this.tropoModel.pathDelay(trackingCoordinates2, station.getOffsetGeodeticPoint(state.getDate()), station.getPressureTemperatureHumidity(state.getDate()), this.tropoModel.getParameters(state2.getDate()), state2.getDate()).getDelay();
            return (d2 - d1) / 10.0;
        }
        return 0.0;
    }

    public <T extends CalculusFieldElement<T>> T rangeRateErrorTroposphericModel(GroundStation station, FieldSpacecraftState<T> state, T[] parameters) {
        Field<T> field = state.getDate().getField();
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        double dt = 10.0;
        FieldVector3D<T> position = state.getPosition();
        FieldTrackingCoordinates<T> trackingCoordinates1 = station.getBaseFrame().getTrackingCoordinates(position, state.getFrame(), state.getDate());
        if (trackingCoordinates1.getElevation().getReal() > 0.0) {
            Object d1 = this.tropoModel.pathDelay(trackingCoordinates1, station.getOffsetGeodeticPoint(state.getDate()), station.getPressureTemperatureHumidity(state.getDate()), (CalculusFieldElement[])parameters, state.getDate()).getDelay();
            TimeShiftable state2 = state.shiftedBy(10.0);
            FieldVector3D position2 = ((FieldSpacecraftState)state2).getPosition();
            FieldTrackingCoordinates trackingCoordinates2 = station.getBaseFrame().getTrackingCoordinates(position2, ((FieldSpacecraftState)state2).getFrame(), ((FieldSpacecraftState)state2).getDate());
            Object d2 = this.tropoModel.pathDelay(trackingCoordinates2, station.getOffsetGeodeticPoint(state.getDate()), station.getPressureTemperatureHumidity(state.getDate()), (CalculusFieldElement[])parameters, ((FieldSpacecraftState)state2).getDate()).getDelay();
            return (T)((CalculusFieldElement)((CalculusFieldElement)d2.subtract(d1)).divide(10.0));
        }
        return (T)zero;
    }

    public List<ParameterDriver> getParametersDrivers() {
        return this.tropoModel.getParametersDrivers();
    }
}

