/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.List;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.MathUtils;
import org.orekit.estimation.measurements.AngularAzEl;
import org.orekit.estimation.measurements.EstimatedMeasurementBase;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.frames.Frame;
import org.orekit.models.earth.troposphere.DiscreteTroposphericModel;
import org.orekit.models.earth.troposphere.TroposphericModel;
import org.orekit.models.earth.troposphere.TroposphericModelAdapter;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TrackingCoordinates;

@Deprecated
public class AngularTroposphericDelayModifier
implements EstimationModifier<AngularAzEl> {
    private final TroposphericModel tropoModel;

    @Deprecated
    public AngularTroposphericDelayModifier(DiscreteTroposphericModel model) {
        this(new TroposphericModelAdapter(model));
    }

    @Deprecated
    public AngularTroposphericDelayModifier(TroposphericModel model) {
        this.tropoModel = model;
    }

    private double angularErrorTroposphericModel(GroundStation station, SpacecraftState state) {
        Vector3D position = state.getPosition();
        TrackingCoordinates trackingCoordinates = station.getBaseFrame().getTrackingCoordinates(position, state.getFrame(), state.getDate());
        if (trackingCoordinates.getElevation() > 0.0) {
            return this.tropoModel.pathDelay(trackingCoordinates, station.getOffsetGeodeticPoint(state.getDate()), station.getPressureTemperatureHumidity(state.getDate()), this.tropoModel.getParameters(state.getDate()), state.getDate()).getDelay();
        }
        return 0.0;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return this.tropoModel.getParametersDrivers();
    }

    @Override
    public void modifyWithoutDerivatives(EstimatedMeasurementBase<AngularAzEl> estimated) {
        AngularAzEl measure = estimated.getObservedMeasurement();
        GroundStation station = measure.getStation();
        SpacecraftState state = estimated.getStates()[0];
        double delay = this.angularErrorTroposphericModel(station, state);
        double dt = delay / 2.99792458E8;
        SpacecraftState transitState = state.shiftedBy(-dt);
        AbsoluteDate date = transitState.getDate();
        Vector3D position = transitState.getPosition();
        Frame inertial = transitState.getFrame();
        TrackingCoordinates tc = station.getBaseFrame().getTrackingCoordinates(position, inertial, date);
        double twoPiWrap = MathUtils.normalizeAngle((double)tc.getAzimuth(), (double)measure.getObservedValue()[0]) - tc.getAzimuth();
        double azimuth = tc.getAzimuth() + twoPiWrap;
        estimated.modifyEstimatedValue(this, azimuth, tc.getElevation());
    }
}

