/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.orekit.estimation.measurements.EstimatedMeasurementBase;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.utils.TimeStampedPVCoordinates;

public class AbstractShapiroBaseModifier {
    private final double s;

    public AbstractShapiroBaseModifier(double gm) {
        this.s = 2.0 * gm / 8.987551787368176E16;
    }

    protected <T extends ObservedMeasurement<T>> void doModify(EstimationModifier<T> modifier, EstimatedMeasurementBase<T> estimated) {
        TimeStampedPVCoordinates[] pv = estimated.getParticipants();
        double correction = pv.length < 3 ? this.shapiroCorrection(pv[0], pv[1]) : 0.5 * (this.shapiroCorrection(pv[0], pv[1]) + this.shapiroCorrection(pv[1], pv[2]));
        double[] newValue = (double[])estimated.getEstimatedValue().clone();
        newValue[0] = newValue[0] + correction;
        estimated.modifyEstimatedValue(modifier, newValue);
    }

    protected double shapiroCorrection(TimeStampedPVCoordinates pvEmitter, TimeStampedPVCoordinates pvReceiver) {
        Vector3D pEmitter = pvEmitter.getPosition();
        Vector3D pReceiver = pvReceiver.getPosition();
        double rEpR = pEmitter.getNorm() + pReceiver.getNorm();
        double d = Vector3D.distance((Vector3D)pEmitter, (Vector3D)pReceiver);
        return this.s * FastMath.log((double)((rEpR + d) / (rEpR - d)));
    }
}

