/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.Collections;
import java.util.List;
import org.orekit.estimation.measurements.EstimatedMeasurementBase;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.estimation.measurements.modifiers.AbstractRelativisticClockModifier;
import org.orekit.utils.ParameterDriver;

public abstract class AbstractRelativisticClockOnBoardRangeRateModifier<T extends ObservedMeasurement<T>>
extends AbstractRelativisticClockModifier
implements EstimationModifier<T> {
    private final double gm;

    public AbstractRelativisticClockOnBoardRangeRateModifier(double gm) {
        this.gm = gm;
    }

    protected double getGm() {
        return this.gm;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    protected void modifyWithoutDerivatives(EstimatedMeasurementBase<T> estimated, double aLocal, double rLocal, double aRemote, double rRemote) {
        double factor = -this.gm * this.getScaleFactor();
        double dfLocal = factor * (1.0 / aLocal - 1.0 / rLocal);
        double dfRemote = factor * (1.0 / aRemote - 1.0 / rRemote);
        double[] newValue = (double[])estimated.getEstimatedValue().clone();
        newValue[0] = newValue[0] + (dfLocal - dfRemote) * 2.99792458E8;
        estimated.modifyEstimatedValue(this, newValue);
    }
}

