/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.estimation.measurements.EstimatedMeasurementBase;
import org.orekit.utils.TimeStampedPVCoordinates;

public class AbstractRelativisticClockModifier {
    private final double s;

    public AbstractRelativisticClockModifier() {
        this.s = -2.225300112107237E-17;
    }

    protected double relativisticCorrection(EstimatedMeasurementBase<?> estimated) {
        TimeStampedPVCoordinates[] pv = estimated.getParticipants();
        return pv.length < 3 ? this.s * (AbstractRelativisticClockModifier.dotProduct(pv[0]) - AbstractRelativisticClockModifier.dotProduct(pv[1])) : this.s * (AbstractRelativisticClockModifier.dotProduct(pv[1]) - AbstractRelativisticClockModifier.dotProduct(pv[2]));
    }

    protected double getScaleFactor() {
        return this.s;
    }

    private static double dotProduct(TimeStampedPVCoordinates pv) {
        return Vector3D.dotProduct((Vector3D)pv.getPosition(), (Vector3D)pv.getVelocity());
    }
}

