/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.modifiers;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.analysis.differentiation.GradientField;
import org.hipparchus.exception.Localizable;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.orekit.annotation.DefaultDataContext;
import org.orekit.data.DataContext;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.estimation.measurements.AngularRaDec;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurementBase;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.frames.FieldTransform;
import org.orekit.frames.Frame;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeSpanMap;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public class AberrationModifier
implements EstimationModifier<AngularRaDec> {
    private final DataContext dataContext;

    @DefaultDataContext
    public AberrationModifier() {
        this(DataContext.getDefault());
    }

    public AberrationModifier(DataContext dataContext) {
        this.dataContext = dataContext;
    }

    @DefaultDataContext
    public static double[] naturalToProper(double[] naturalRaDec, GroundStation station, AbsoluteDate date, Frame frame) {
        return AberrationModifier.naturalToProper(naturalRaDec, station, date, frame, DataContext.getDefault());
    }

    public static double[] naturalToProper(double[] naturalRaDec, GroundStation station, AbsoluteDate date, Frame frame, DataContext context) {
        AberrationModifier.ensureFrameIsPseudoInertial(frame);
        TimeStampedPVCoordinates baryPV = context.getCelestialBodies().getSolarSystemBarycenter().getPVCoordinates(date, frame);
        TimeStampedPVCoordinates stationPV = station.getBaseFrame().getPVCoordinates(date, frame);
        Vector3D stationBaryVel = stationPV.getVelocity().subtract((Vector)baryPV.getVelocity()).scalarMultiply(3.3356409519815204E-9);
        return AberrationModifier.lorentzVelocitySum(naturalRaDec, stationBaryVel);
    }

    @DefaultDataContext
    public static double[] properToNatural(double[] properRaDec, GroundStation station, AbsoluteDate date, Frame frame) {
        return AberrationModifier.properToNatural(properRaDec, station, date, frame, DataContext.getDefault());
    }

    public static double[] properToNatural(double[] properRaDec, GroundStation station, AbsoluteDate date, Frame frame, DataContext context) {
        AberrationModifier.ensureFrameIsPseudoInertial(frame);
        TimeStampedPVCoordinates baryPV = context.getCelestialBodies().getSolarSystemBarycenter().getPVCoordinates(date, frame);
        TimeStampedPVCoordinates stationPV = station.getBaseFrame().getPVCoordinates(date, frame);
        Vector3D baryStationVel = baryPV.getVelocity().subtract((Vector)stationPV.getVelocity()).scalarMultiply(3.3356409519815204E-9);
        return AberrationModifier.lorentzVelocitySum(properRaDec, baryStationVel);
    }

    private static double[] lorentzVelocitySum(double[] raDec, Vector3D velocity) {
        Vector3D direction = new Vector3D(raDec[0], raDec[1]);
        double inverseBeta = FastMath.sqrt((double)(1.0 - velocity.getNormSq()));
        double velocityScale = 1.0 + direction.dotProduct((Vector)velocity) / (1.0 + inverseBeta);
        Vector3D transformDirection = direction.scalarMultiply(inverseBeta).add((Vector)velocity.scalarMultiply(velocityScale));
        return new double[]{transformDirection.getAlpha(), transformDirection.getDelta()};
    }

    @DefaultDataContext
    public static Gradient[] fieldNaturalToProper(Gradient[] naturalRaDec, FieldTransform<Gradient> stationToInertial, Frame frame) {
        return AberrationModifier.fieldNaturalToProper(naturalRaDec, stationToInertial, frame, DataContext.getDefault());
    }

    public static Gradient[] fieldNaturalToProper(Gradient[] naturalRaDec, FieldTransform<Gradient> stationToInertial, Frame frame, DataContext context) {
        AberrationModifier.ensureFrameIsPseudoInertial(frame);
        GradientField field = naturalRaDec[0].getField();
        FieldVector3D zero = FieldVector3D.getZero((Field)field);
        FieldAbsoluteDate<Gradient> date = stationToInertial.getFieldDate();
        TimeStampedFieldPVCoordinates<Gradient> baryPV = context.getCelestialBodies().getSolarSystemBarycenter().getPVCoordinates(date, frame);
        TimeStampedFieldPVCoordinates<Gradient> stationPV = stationToInertial.transformPVCoordinates(new TimeStampedFieldPVCoordinates<Gradient>(date, zero, zero, zero));
        FieldVector3D stationBaryVel = stationPV.getVelocity().subtract(baryPV.getVelocity()).scalarMultiply(3.3356409519815204E-9);
        return AberrationModifier.fieldLorentzVelocitySum(naturalRaDec, (FieldVector3D<Gradient>)stationBaryVel);
    }

    @DefaultDataContext
    public static Gradient[] fieldProperToNatural(Gradient[] properRaDec, FieldTransform<Gradient> stationToInertial, Frame frame) {
        return AberrationModifier.fieldProperToNatural(properRaDec, stationToInertial, frame, DataContext.getDefault());
    }

    public static Gradient[] fieldProperToNatural(Gradient[] properRaDec, FieldTransform<Gradient> stationToInertial, Frame frame, DataContext context) {
        AberrationModifier.ensureFrameIsPseudoInertial(frame);
        GradientField field = properRaDec[0].getField();
        FieldVector3D zero = FieldVector3D.getZero((Field)field);
        FieldAbsoluteDate<Gradient> date = stationToInertial.getFieldDate();
        TimeStampedFieldPVCoordinates<Gradient> baryPV = context.getCelestialBodies().getSolarSystemBarycenter().getPVCoordinates(date, frame);
        TimeStampedFieldPVCoordinates<Gradient> stationPV = stationToInertial.transformPVCoordinates(new TimeStampedFieldPVCoordinates<Gradient>(date, zero, zero, zero));
        FieldVector3D stationBaryVel = stationPV.getVelocity().negate().add(baryPV.getVelocity()).scalarMultiply(3.3356409519815204E-9);
        return AberrationModifier.fieldLorentzVelocitySum(properRaDec, (FieldVector3D<Gradient>)stationBaryVel);
    }

    private static Gradient[] fieldLorentzVelocitySum(Gradient[] raDec, FieldVector3D<Gradient> velocity) {
        FieldVector3D direction = new FieldVector3D((CalculusFieldElement)raDec[0], (CalculusFieldElement)raDec[1]);
        Gradient inverseBeta = (Gradient)((Gradient)((Gradient)velocity.getNormSq()).negate().add(1.0)).sqrt();
        Gradient velocityScale = (Gradient)((Gradient)direction.dotProduct(velocity)).divide((Gradient)inverseBeta.add(1.0)).add(1.0);
        FieldVector3D transformDirection = direction.scalarMultiply((CalculusFieldElement)inverseBeta).add(velocity.scalarMultiply((CalculusFieldElement)velocityScale));
        return new Gradient[]{(Gradient)transformDirection.getAlpha(), (Gradient)transformDirection.getDelta()};
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    @Override
    public void modifyWithoutDerivatives(EstimatedMeasurementBase<AngularRaDec> estimated) {
        AbsoluteDate date = estimated.getDate();
        GroundStation station = estimated.getObservedMeasurement().getStation();
        Frame frame = estimated.getObservedMeasurement().getReferenceFrame();
        double[] estimatedRaDec = estimated.getEstimatedValue();
        double[] naturalRaDec = AberrationModifier.properToNatural(estimatedRaDec, station, date, frame, this.dataContext);
        double[] observed = estimated.getObservedValue();
        double baseRightAscension = naturalRaDec[0];
        double twoPiWrap = MathUtils.normalizeAngle((double)baseRightAscension, (double)observed[0]) - baseRightAscension;
        double rightAscension = baseRightAscension + twoPiWrap;
        estimated.modifyEstimatedValue(this, rightAscension, naturalRaDec[1]);
    }

    @Override
    public void modify(EstimatedMeasurement<AngularRaDec> estimated) {
        AbsoluteDate date = estimated.getDate();
        Frame frame = ((AngularRaDec)estimated.getObservedMeasurement()).getReferenceFrame();
        int nbParams = 6;
        HashMap<String, Integer> indices = new HashMap<String, Integer>();
        for (ParameterDriver driver : ((AngularRaDec)estimated.getObservedMeasurement()).getParametersDrivers()) {
            if (!driver.isSelected()) continue;
            for (TimeSpanMap.Span<String> span = driver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                if (indices.containsKey(span.getData())) continue;
                indices.put(span.getData(), nbParams++);
            }
        }
        GradientField field = GradientField.getField((int)nbParams);
        FieldTransform<Gradient> stationToInertial = ((AngularRaDec)estimated.getObservedMeasurement()).getStation().getOffsetToInertial(frame, date, nbParams, indices);
        double[] estimatedRaDec = estimated.getEstimatedValue();
        Gradient[] estimatedRaDecDS = new Gradient[]{(Gradient)((Gradient)field.getZero()).add(estimatedRaDec[0]), (Gradient)((Gradient)field.getZero()).add(estimatedRaDec[1])};
        Gradient[] naturalRaDec = AberrationModifier.fieldProperToNatural(estimatedRaDecDS, stationToInertial, frame, this.dataContext);
        double[] observed = estimated.getObservedValue();
        Gradient baseRightAscension = naturalRaDec[0];
        double twoPiWrap = MathUtils.normalizeAngle((double)baseRightAscension.getReal(), (double)observed[0]) - baseRightAscension.getReal();
        Gradient rightAscension = (Gradient)baseRightAscension.add(twoPiWrap);
        estimated.modifyEstimatedValue(this, rightAscension.getValue(), naturalRaDec[1].getValue());
        double[] raDerivatives = rightAscension.getGradient();
        double[] decDerivatives = naturalRaDec[1].getGradient();
        for (ParameterDriver driver : ((AngularRaDec)estimated.getObservedMeasurement()).getParametersDrivers()) {
            for (TimeSpanMap.Span<String> span = driver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                Integer index = (Integer)indices.get(span.getData());
                if (index == null) continue;
                double[] parameterDerivative = estimated.getParameterDerivatives(driver);
                parameterDerivative[0] = parameterDerivative[0] + raDerivatives[index];
                parameterDerivative[1] = parameterDerivative[1] + decDerivatives[index];
                estimated.setParameterDerivatives(driver, span.getStart(), parameterDerivative[0], parameterDerivative[1]);
            }
        }
    }

    private static void ensureFrameIsPseudoInertial(Frame frame) {
        if (!frame.isPseudoInertial()) {
            throw new OrekitException((Localizable)OrekitMessages.NON_PSEUDO_INERTIAL_FRAME, frame.getName());
        }
    }
}

