/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.gnss;

import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.orekit.estimation.measurements.EstimatedMeasurementBase;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.gnss.AbstractWindUp;
import org.orekit.estimation.measurements.gnss.Dipole;
import org.orekit.estimation.measurements.gnss.Phase;
import org.orekit.frames.Frame;
import org.orekit.utils.TimeStampedPVCoordinates;

public class WindUp
extends AbstractWindUp<Phase> {
    WindUp(Dipole emitter) {
        super(emitter, Dipole.CANONICAL_I_J);
    }

    @Override
    protected Rotation emitterToInert(EstimatedMeasurementBase<Phase> estimated) {
        return estimated.getStates()[0].toStaticTransform().getRotation().revert();
    }

    @Override
    protected Rotation receiverToInert(EstimatedMeasurementBase<Phase> estimated) {
        TimeStampedPVCoordinates[] participants = estimated.getParticipants();
        Frame inertial = estimated.getStates()[0].getFrame();
        GroundStation station = estimated.getObservedMeasurement().getStation();
        return station.getOffsetToInertial(inertial, participants[1].getDate(), false).getRotation();
    }
}

