/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.gnss;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hipparchus.fitting.PolynomialCurveFitter;
import org.hipparchus.fitting.WeightedObservedPoint;
import org.hipparchus.util.FastMath;
import org.orekit.estimation.measurements.gnss.AbstractCycleSlipDetector;
import org.orekit.estimation.measurements.gnss.CombinedObservationData;
import org.orekit.estimation.measurements.gnss.CycleSlipDetectorResults;
import org.orekit.estimation.measurements.gnss.MeasurementCombinationFactory;
import org.orekit.estimation.measurements.gnss.PhaseMinusCodeCombination;
import org.orekit.files.rinex.observation.ObservationData;
import org.orekit.files.rinex.observation.ObservationDataSet;
import org.orekit.gnss.Frequency;
import org.orekit.gnss.MeasurementType;
import org.orekit.gnss.SatelliteSystem;
import org.orekit.time.AbsoluteDate;

public class PhaseMinusCodeCycleSlipDetector
extends AbstractCycleSlipDetector {
    private final int order;
    private final double threshold;

    public PhaseMinusCodeCycleSlipDetector(double dt, double threshold, int n, int order) {
        super(dt, n);
        this.threshold = threshold;
        this.order = order;
    }

    @Override
    protected void manageData(ObservationDataSet observation) {
        SatelliteSystem system = observation.getSatellite().getSystem();
        int prn = observation.getSatellite().getPRN();
        AbsoluteDate date = observation.getDate();
        ArrayList<ObservationData> pseudoRanges = new ArrayList<ObservationData>();
        ArrayList<ObservationData> phases = new ArrayList<ObservationData>();
        for (ObservationData od : observation.getObservationData()) {
            if (Double.isNaN(od.getValue())) continue;
            if (od.getObservationType().getMeasurementType() == MeasurementType.PSEUDO_RANGE) {
                pseudoRanges.add(od);
                continue;
            }
            if (od.getObservationType().getMeasurementType() != MeasurementType.CARRIER_PHASE) continue;
            phases.add(od);
        }
        for (ObservationData phase : phases) {
            for (ObservationData pseudoRange : pseudoRanges) {
                double wavelength = phase.getObservationType().getFrequency(system).getWavelength();
                ObservationData phaseInMeters = new ObservationData(phase.getObservationType(), wavelength * phase.getValue(), phase.getLossOfLockIndicator(), phase.getSignalStrength());
                if (phase.getObservationType().getFrequency(system) != pseudoRange.getObservationType().getFrequency(system)) continue;
                PhaseMinusCodeCombination phaseMinusCode = MeasurementCombinationFactory.getPhaseMinusCodeCombination(system);
                CombinedObservationData cod = phaseMinusCode.combine(phaseInMeters, pseudoRange);
                String nameSat = this.setName(prn, observation.getSatellite().getSystem());
                boolean slip = this.cycleSlipDetection(nameSat, date, cod.getValue(), phase.getObservationType().getFrequency(system));
                if (slip) continue;
                this.cycleSlipDataSet(nameSat, date, cod.getValue(), phase.getObservationType().getFrequency(system));
            }
        }
    }

    private boolean cycleSlipDetection(String nameSat, AbsoluteDate currentDate, double phaseMinusCode, Frequency frequency) {
        List<CycleSlipDetectorResults> data = this.getResults();
        List<Map<Frequency, AbstractCycleSlipDetector.DataForDetection>> stuff = this.getStuffReference();
        if (data != null) {
            for (CycleSlipDetectorResults resultPmC : data) {
                if (resultPmC.getSatelliteName().compareTo(nameSat) != 0 || !resultPmC.getCycleSlipMap().containsKey(frequency)) continue;
                Map<Frequency, AbstractCycleSlipDetector.DataForDetection> values = stuff.get(data.indexOf(resultPmC));
                AbstractCycleSlipDetector.DataForDetection v = values.get(frequency);
                if (FastMath.abs((double)currentDate.durationFrom(v.getFiguresReference()[v.getWrite()].getDate())) > this.getMaxTimeBeetween2Measurement()) {
                    resultPmC.addCycleSlipDate(frequency, currentDate);
                    v.resetFigures(new AbstractCycleSlipDetector.SlipComputationData[this.getMinMeasurementNumber()], phaseMinusCode, currentDate);
                    resultPmC.setDate(frequency, currentDate);
                    return true;
                }
                if (v.getCanBeComputed() < this.getMinMeasurementNumber()) break;
                ArrayList<WeightedObservedPoint> xy = new ArrayList<WeightedObservedPoint>();
                for (int i = 0; i < this.getMinMeasurementNumber(); ++i) {
                    AbstractCycleSlipDetector.SlipComputationData current = v.getFiguresReference()[i];
                    xy.add(new WeightedObservedPoint(1.0, current.getDate().durationFrom(currentDate), current.getValue()));
                }
                PolynomialCurveFitter fitting = PolynomialCurveFitter.create((int)this.order);
                if (!(FastMath.abs((double)(fitting.fit(xy)[0] - phaseMinusCode)) > this.threshold)) continue;
                resultPmC.addCycleSlipDate(frequency, currentDate);
                v.resetFigures(new AbstractCycleSlipDetector.SlipComputationData[this.getMinMeasurementNumber()], phaseMinusCode, currentDate);
                resultPmC.setDate(frequency, currentDate);
                return true;
            }
        }
        return false;
    }
}

