/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.gnss;

import java.util.Map;
import org.hipparchus.random.CorrelatedRandomVectorGenerator;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.estimation.measurements.generation.AbstractMeasurementBuilder;
import org.orekit.estimation.measurements.gnss.AmbiguityCache;
import org.orekit.estimation.measurements.gnss.Phase;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.sampling.OrekitStepInterpolator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class PhaseBuilder
extends AbstractMeasurementBuilder<Phase> {
    private final AmbiguityCache cache;
    private final GroundStation station;
    private final double wavelength;
    private final ObservableSatellite satellite;

    @Deprecated
    public PhaseBuilder(CorrelatedRandomVectorGenerator noiseSource, GroundStation station, double wavelength, double sigma, double baseWeight, ObservableSatellite satellite) {
        this(noiseSource, station, wavelength, sigma, baseWeight, satellite, AmbiguityCache.DEFAULT_CACHE);
    }

    public PhaseBuilder(CorrelatedRandomVectorGenerator noiseSource, GroundStation station, double wavelength, double sigma, double baseWeight, ObservableSatellite satellite, AmbiguityCache cache) {
        super(noiseSource, sigma, baseWeight, satellite);
        this.station = station;
        this.wavelength = wavelength;
        this.satellite = satellite;
        this.cache = cache;
    }

    @Override
    public Phase build(AbsoluteDate date, Map<ObservableSatellite, OrekitStepInterpolator> interpolators) {
        double sigma = this.getTheoreticalStandardDeviation()[0];
        double baseWeight = this.getBaseWeight()[0];
        SpacecraftState[] relevant = new SpacecraftState[]{interpolators.get(this.satellite).getInterpolatedState(date)};
        Phase dummy = new Phase(this.station, relevant[0].getDate(), Double.NaN, this.wavelength, sigma, baseWeight, this.satellite, this.cache);
        for (EstimationModifier modifier : this.getModifiers()) {
            dummy.addModifier(modifier);
        }
        for (ParameterDriver driver : dummy.getParametersDrivers()) {
            AbsoluteDate end;
            if (driver.getReferenceDate() != null) continue;
            AbsoluteDate start = this.getStart();
            driver.setReferenceDate(start.durationFrom(end = this.getEnd()) <= 0.0 ? start : end);
        }
        double phase = dummy.estimateWithoutDerivatives(relevant).getEstimatedValue()[0];
        double[] noise = this.getNoise();
        if (noise != null) {
            phase += noise[0];
        }
        Phase measurement = new Phase(this.station, relevant[0].getDate(), phase, this.wavelength, sigma, baseWeight, this.satellite, this.cache);
        for (EstimationModifier modifier : this.getModifiers()) {
            measurement.addModifier(modifier);
        }
        return measurement;
    }
}

