/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.gnss;

import java.util.Arrays;
import org.hipparchus.analysis.differentiation.Gradient;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurementBase;
import org.orekit.estimation.measurements.GroundReceiverCommonParametersWithDerivatives;
import org.orekit.estimation.measurements.GroundReceiverCommonParametersWithoutDerivatives;
import org.orekit.estimation.measurements.GroundReceiverMeasurement;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.estimation.measurements.gnss.AmbiguityCache;
import org.orekit.estimation.measurements.gnss.AmbiguityDriver;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeSpanMap;
import org.orekit.utils.TimeStampedPVCoordinates;

public class Phase
extends GroundReceiverMeasurement<Phase> {
    public static final String MEASUREMENT_TYPE = "Phase";
    @Deprecated
    public static final String AMBIGUITY_NAME = "ambiguity";
    private final AmbiguityDriver ambiguityDriver;
    private final double wavelength;

    @Deprecated
    public Phase(GroundStation station, AbsoluteDate date, double phase, double wavelength, double sigma, double baseWeight, ObservableSatellite satellite) {
        this(station, date, phase, wavelength, sigma, baseWeight, satellite, AmbiguityCache.DEFAULT_CACHE);
    }

    public Phase(GroundStation station, AbsoluteDate date, double phase, double wavelength, double sigma, double baseWeight, ObservableSatellite satellite, AmbiguityCache cache) {
        super(station, false, date, phase, sigma, baseWeight, satellite);
        this.ambiguityDriver = cache.getAmbiguity(satellite.getName(), station.getBaseFrame().getName(), wavelength);
        this.addParameterDriver(this.ambiguityDriver);
        this.wavelength = wavelength;
    }

    public double getWavelength() {
        return this.wavelength;
    }

    public AmbiguityDriver getAmbiguityDriver() {
        return this.ambiguityDriver;
    }

    @Override
    protected EstimatedMeasurementBase<Phase> theoreticalEvaluationWithoutDerivatives(int iteration, int evaluation, SpacecraftState[] states) {
        GroundReceiverCommonParametersWithoutDerivatives common = this.computeCommonParametersWithout(states[0]);
        EstimatedMeasurementBase<Phase> estimated = new EstimatedMeasurementBase<Phase>(this, iteration, evaluation, new SpacecraftState[]{common.getTransitState()}, new TimeStampedPVCoordinates[]{common.getTransitPV(), common.getStationDownlink()});
        ObservableSatellite satellite = this.getSatellites().get(0);
        double dts = satellite.getClockOffsetDriver().getValue(common.getState().getDate());
        double dtg = this.getStation().getClockOffsetDriver().getValue(this.getDate());
        double cOverLambda = 2.99792458E8 / this.wavelength;
        double ambiguity = this.ambiguityDriver.getValue(common.getState().getDate());
        double phase = (common.getTauD() + dtg - dts) * cOverLambda + ambiguity;
        estimated.setEstimatedValue(phase);
        return estimated;
    }

    @Override
    protected EstimatedMeasurement<Phase> theoreticalEvaluation(int iteration, int evaluation, SpacecraftState[] states) {
        SpacecraftState state = states[0];
        GroundReceiverCommonParametersWithDerivatives common = this.computeCommonParametersWithDerivatives(state);
        int nbParams = common.getTauD().getFreeParameters();
        EstimatedMeasurement<Phase> estimated = new EstimatedMeasurement<Phase>(this, iteration, evaluation, new SpacecraftState[]{common.getTransitState()}, new TimeStampedPVCoordinates[]{common.getTransitPV().toTimeStampedPVCoordinates(), common.getStationDownlink().toTimeStampedPVCoordinates()});
        ObservableSatellite satellite = this.getSatellites().get(0);
        Gradient dts = satellite.getClockOffsetDriver().getValue(nbParams, common.getIndices(), state.getDate());
        Gradient dtg = this.getStation().getClockOffsetDriver().getValue(nbParams, common.getIndices(), this.getDate());
        double cOverLambda = 2.99792458E8 / this.wavelength;
        Gradient ambiguity = this.ambiguityDriver.getValue(nbParams, common.getIndices(), state.getDate());
        Gradient phase = common.getTauD().add(dtg).subtract(dts).multiply(cOverLambda).add(ambiguity);
        estimated.setEstimatedValue(phase.getValue());
        double[] derivatives = phase.getGradient();
        estimated.setStateDerivatives(0, new double[][]{Arrays.copyOfRange(derivatives, 0, 6)});
        for (ParameterDriver driver : this.getParametersDrivers()) {
            for (TimeSpanMap.Span<String> span = driver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                Integer index = common.getIndices().get(span.getData());
                if (index == null) continue;
                estimated.setParameterDerivatives(driver, span.getStart(), derivatives[index]);
            }
        }
        return estimated;
    }
}

