/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.gnss;

import java.util.Arrays;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurementBase;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.estimation.measurements.QuadraticClockModel;
import org.orekit.estimation.measurements.gnss.AbstractOneWayGNSSMeasurement;
import org.orekit.estimation.measurements.gnss.OnBoardCommonParametersWithDerivatives;
import org.orekit.estimation.measurements.gnss.OnBoardCommonParametersWithoutDerivatives;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeSpanMap;
import org.orekit.utils.TimeStampedPVCoordinates;

public class OneWayGNSSRangeRate
extends AbstractOneWayGNSSMeasurement<OneWayGNSSRangeRate> {
    public static final String MEASUREMENT_TYPE = "OneWayGNSSRangeRate";

    public OneWayGNSSRangeRate(PVCoordinatesProvider remote, double dtRemote, AbsoluteDate date, double rangeRate, double sigma, double baseWeight, ObservableSatellite local) {
        this(remote, new QuadraticClockModel(date, dtRemote, 0.0, 0.0), date, rangeRate, sigma, baseWeight, local);
    }

    public OneWayGNSSRangeRate(PVCoordinatesProvider remote, QuadraticClockModel remoteClock, AbsoluteDate date, double rangeRate, double sigma, double baseWeight, ObservableSatellite local) {
        super(remote, remoteClock, date, rangeRate, sigma, baseWeight, local);
    }

    @Override
    protected EstimatedMeasurementBase<OneWayGNSSRangeRate> theoreticalEvaluationWithoutDerivatives(int iteration, int evaluation, SpacecraftState[] states) {
        OnBoardCommonParametersWithoutDerivatives common = this.computeCommonParametersWithout(states, false);
        EstimatedMeasurementBase<OneWayGNSSRangeRate> estimatedRangeRate = new EstimatedMeasurementBase<OneWayGNSSRangeRate>(this, iteration, evaluation, new SpacecraftState[]{common.getState()}, new TimeStampedPVCoordinates[]{common.getRemotePV(), common.getTransitPV()});
        PVCoordinates delta = new PVCoordinates(common.getRemotePV(), (PVCoordinates)common.getTransitPV());
        double rangeRate = Vector3D.dotProduct((Vector3D)delta.getVelocity(), (Vector3D)((Vector3D)delta.getPosition().normalize())) + 2.99792458E8 * (common.getLocalRate() - common.getRemoteRate());
        estimatedRangeRate.setEstimatedValue(rangeRate);
        return estimatedRangeRate;
    }

    @Override
    protected EstimatedMeasurement<OneWayGNSSRangeRate> theoreticalEvaluation(int iteration, int evaluation, SpacecraftState[] states) {
        OnBoardCommonParametersWithDerivatives common = this.computeCommonParametersWith(states, false);
        EstimatedMeasurement<OneWayGNSSRangeRate> estimatedRangeRate = new EstimatedMeasurement<OneWayGNSSRangeRate>(this, iteration, evaluation, new SpacecraftState[]{common.getState()}, new TimeStampedPVCoordinates[]{common.getRemotePV().toTimeStampedPVCoordinates(), common.getTransitPV().toTimeStampedPVCoordinates()});
        FieldPVCoordinates<Gradient> delta = new FieldPVCoordinates<Gradient>(common.getRemotePV(), common.getTransitPV());
        Gradient rangeRate = ((Gradient)FieldVector3D.dotProduct(delta.getVelocity(), (FieldVector3D)delta.getPosition().normalize())).add(common.getLocalRate().subtract(common.getRemoteRate()).multiply(2.99792458E8));
        double[] rangeRateDerivatives = rangeRate.getGradient();
        estimatedRangeRate.setEstimatedValue(rangeRate.getValue());
        estimatedRangeRate.setStateDerivatives(0, new double[][]{Arrays.copyOfRange(rangeRateDerivatives, 0, 6)});
        for (ParameterDriver measurementDriver : this.getParametersDrivers()) {
            for (TimeSpanMap.Span<String> span = measurementDriver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                Integer index = common.getIndices().get(span.getData());
                if (index == null) continue;
                estimatedRangeRate.setParameterDerivatives(measurementDriver, span.getStart(), rangeRateDerivatives[index]);
            }
        }
        return estimatedRangeRate;
    }
}

