/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.gnss;

import java.util.Arrays;
import org.hipparchus.analysis.differentiation.Gradient;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurementBase;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.estimation.measurements.QuadraticClockModel;
import org.orekit.estimation.measurements.gnss.AbstractOneWayGNSSMeasurement;
import org.orekit.estimation.measurements.gnss.OnBoardCommonParametersWithDerivatives;
import org.orekit.estimation.measurements.gnss.OnBoardCommonParametersWithoutDerivatives;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeSpanMap;
import org.orekit.utils.TimeStampedPVCoordinates;

public class OneWayGNSSRange
extends AbstractOneWayGNSSMeasurement<OneWayGNSSRange> {
    public static final String MEASUREMENT_TYPE = "OneWayGNSSRange";

    public OneWayGNSSRange(PVCoordinatesProvider remote, double dtRemote, AbsoluteDate date, double range, double sigma, double baseWeight, ObservableSatellite local) {
        this(remote, new QuadraticClockModel(date, dtRemote, 0.0, 0.0), date, range, sigma, baseWeight, local);
    }

    public OneWayGNSSRange(PVCoordinatesProvider remote, QuadraticClockModel remoteClock, AbsoluteDate date, double range, double sigma, double baseWeight, ObservableSatellite local) {
        super(remote, remoteClock, date, range, sigma, baseWeight, local);
    }

    @Override
    protected EstimatedMeasurementBase<OneWayGNSSRange> theoreticalEvaluationWithoutDerivatives(int iteration, int evaluation, SpacecraftState[] states) {
        OnBoardCommonParametersWithoutDerivatives common = this.computeCommonParametersWithout(states, false);
        EstimatedMeasurementBase<OneWayGNSSRange> estimatedRange = new EstimatedMeasurementBase<OneWayGNSSRange>(this, iteration, evaluation, new SpacecraftState[]{common.getState()}, new TimeStampedPVCoordinates[]{common.getRemotePV(), common.getTransitPV()});
        double range = (common.getTauD() + common.getLocalOffset() - common.getRemoteOffset()) * 2.99792458E8;
        estimatedRange.setEstimatedValue(range);
        return estimatedRange;
    }

    @Override
    protected EstimatedMeasurement<OneWayGNSSRange> theoreticalEvaluation(int iteration, int evaluation, SpacecraftState[] states) {
        OnBoardCommonParametersWithDerivatives common = this.computeCommonParametersWith(states, false);
        EstimatedMeasurement<OneWayGNSSRange> estimatedRange = new EstimatedMeasurement<OneWayGNSSRange>(this, iteration, evaluation, new SpacecraftState[]{common.getState()}, new TimeStampedPVCoordinates[]{common.getRemotePV().toTimeStampedPVCoordinates(), common.getTransitPV().toTimeStampedPVCoordinates()});
        Gradient range = common.getTauD().add(common.getLocalOffset()).subtract(common.getRemoteOffset()).multiply(2.99792458E8);
        double[] rangeDerivatives = range.getGradient();
        estimatedRange.setEstimatedValue(range.getValue());
        estimatedRange.setStateDerivatives(0, new double[][]{Arrays.copyOfRange(rangeDerivatives, 0, 6)});
        for (ParameterDriver measurementDriver : this.getParametersDrivers()) {
            for (TimeSpanMap.Span<String> span = measurementDriver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                Integer index = common.getIndices().get(span.getData());
                if (index == null) continue;
                estimatedRange.setParameterDerivatives(measurementDriver, span.getStart(), rangeDerivatives[index]);
            }
        }
        return estimatedRange;
    }
}

