/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.gnss;

import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Map;
import org.hipparchus.analysis.differentiation.Gradient;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurementBase;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.estimation.measurements.QuadraticClockModel;
import org.orekit.estimation.measurements.gnss.AbstractOneWayGNSSMeasurement;
import org.orekit.estimation.measurements.gnss.AmbiguityCache;
import org.orekit.estimation.measurements.gnss.AmbiguityDriver;
import org.orekit.estimation.measurements.gnss.OnBoardCommonParametersWithDerivatives;
import org.orekit.estimation.measurements.gnss.OnBoardCommonParametersWithoutDerivatives;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeSpanMap;
import org.orekit.utils.TimeStampedPVCoordinates;

public class OneWayGNSSPhase
extends AbstractOneWayGNSSMeasurement<OneWayGNSSPhase> {
    public static final String MEASUREMENT_TYPE = "OneWayGNSSPhase";
    @Deprecated
    public static final String AMBIGUITY_NAME = "ambiguity";
    @Deprecated
    private static final Map<PVCoordinatesProvider, String> REMOTE_NAMES = new IdentityHashMap<PVCoordinatesProvider, String>();
    private final AmbiguityDriver ambiguityDriver;
    private final double wavelength;

    @Deprecated
    public OneWayGNSSPhase(PVCoordinatesProvider remote, double dtRemote, AbsoluteDate date, double phase, double wavelength, double sigma, double baseWeight, ObservableSatellite local) {
        this(remote, REMOTE_NAMES.computeIfAbsent(remote, r -> "remote-" + REMOTE_NAMES.size()), new QuadraticClockModel(date, dtRemote, 0.0, 0.0), date, phase, wavelength, sigma, baseWeight, local, AmbiguityCache.DEFAULT_CACHE);
    }

    public OneWayGNSSPhase(PVCoordinatesProvider remote, String remoteName, QuadraticClockModel remoteClock, AbsoluteDate date, double phase, double wavelength, double sigma, double baseWeight, ObservableSatellite local, AmbiguityCache cache) {
        super(remote, remoteClock, date, phase, sigma, baseWeight, local);
        this.ambiguityDriver = cache.getAmbiguity(remoteName, local.getName(), wavelength);
        this.addParameterDriver(this.ambiguityDriver);
        this.addParameterDriver(local.getClockOffsetDriver());
        this.wavelength = wavelength;
    }

    public double getWavelength() {
        return this.wavelength;
    }

    public AmbiguityDriver getAmbiguityDriver() {
        return this.ambiguityDriver;
    }

    @Override
    protected EstimatedMeasurementBase<OneWayGNSSPhase> theoreticalEvaluationWithoutDerivatives(int iteration, int evaluation, SpacecraftState[] states) {
        OnBoardCommonParametersWithoutDerivatives common = this.computeCommonParametersWithout(states, false);
        EstimatedMeasurementBase<OneWayGNSSPhase> estimatedPhase = new EstimatedMeasurementBase<OneWayGNSSPhase>(this, iteration, evaluation, new SpacecraftState[]{common.getState()}, new TimeStampedPVCoordinates[]{common.getRemotePV(), common.getTransitPV()});
        double cOverLambda = 2.99792458E8 / this.wavelength;
        double ambiguity = this.ambiguityDriver.getValue(common.getState().getDate());
        double phase = (common.getTauD() + common.getLocalOffset() - common.getRemoteOffset()) * cOverLambda + ambiguity;
        estimatedPhase.setEstimatedValue(phase);
        return estimatedPhase;
    }

    @Override
    protected EstimatedMeasurement<OneWayGNSSPhase> theoreticalEvaluation(int iteration, int evaluation, SpacecraftState[] states) {
        OnBoardCommonParametersWithDerivatives common = this.computeCommonParametersWith(states, false);
        EstimatedMeasurement<OneWayGNSSPhase> estimatedPhase = new EstimatedMeasurement<OneWayGNSSPhase>(this, iteration, evaluation, new SpacecraftState[]{common.getState()}, new TimeStampedPVCoordinates[]{common.getRemotePV().toTimeStampedPVCoordinates(), common.getTransitPV().toTimeStampedPVCoordinates()});
        double cOverLambda = 2.99792458E8 / this.wavelength;
        Gradient ambiguity = this.ambiguityDriver.getValue(common.getTauD().getFreeParameters(), common.getIndices(), common.getState().getDate());
        Gradient phase = common.getTauD().add(common.getLocalOffset()).subtract(common.getRemoteOffset()).multiply(cOverLambda).add(ambiguity);
        double[] phaseDerivatives = phase.getGradient();
        estimatedPhase.setEstimatedValue(phase.getValue());
        estimatedPhase.setStateDerivatives(0, new double[][]{Arrays.copyOfRange(phaseDerivatives, 0, 6)});
        for (ParameterDriver phaseMeasurementDriver : this.getParametersDrivers()) {
            for (TimeSpanMap.Span<String> span = phaseMeasurementDriver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                Integer index = common.getIndices().get(span.getData());
                if (index == null) continue;
                estimatedPhase.setParameterDerivatives(phaseMeasurementDriver, span.getStart(), phaseDerivatives[index]);
            }
        }
        return estimatedPhase;
    }
}

