/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.gnss;

import org.hipparchus.util.FastMath;
import org.orekit.estimation.measurements.gnss.AbstractLambdaMethod;

public class ModifiedLambdaMethod
extends AbstractLambdaMethod {
    @Override
    protected void ltdlDecomposition() {
        double[] diag = this.getDiagReference();
        double[] low = this.getLowReference();
        int[] Z = this.getZInverseTransformationReference();
        double[] aNew = this.getDecorrelatedReference();
        for (int i = 0; i < this.getSize(); ++i) {
            Z[this.zIndex((int)i, (int)i)] = 0;
        }
        int n = diag.length;
        int[] perm = new int[n];
        for (int i = 0; i < n; ++i) {
            perm[i] = i;
        }
        for (int k = n - 1; k >= 0; --k) {
            int q = this.posMin(diag, k);
            this.exchangeIntP1WithIntP2(perm, k, q);
            this.permRowThenCol(low, diag, k, q);
            if (k > 0) {
                double Wkk = diag[k];
                this.divide(low, Wkk, k);
                this.set(low, diag, k);
            }
            this.exchangeDoubleP1WithDoubleP2(aNew, k, q);
        }
        for (int j = 0; j < n; ++j) {
            Z[this.zIndex((int)j, (int)perm[j])] = 1;
        }
    }

    @Override
    protected void reduction() {
        double[] diag = this.getDiagReference();
        double[] low = this.getLowReference();
        int n = diag.length;
        int k = this.getSize() - 2;
        while (k > -1) {
            double delta;
            int kp1 = k + 1;
            double tmp = low[this.lIndex(kp1, k)];
            double mu = FastMath.rint((double)tmp);
            if (Math.abs(mu) > 1.0E-9) {
                tmp -= mu;
            }
            if ((delta = diag[k] + tmp * tmp * diag[kp1]) < diag[kp1]) {
                this.integerGaussTransformation(kp1, k);
                if (mu > 0.0) {
                    for (int i = k + 2; i < n; ++i) {
                        this.integerGaussTransformation(i, k);
                    }
                }
                this.permutation(k, delta);
                if (k >= n - 2) continue;
                ++k;
                continue;
            }
            --k;
        }
    }

    @Override
    protected void discreteSearch() {
        int n = this.getSize();
        int maxSolutions = this.getMaxSolution();
        double[] diag = this.getDiagReference();
        double[] decorrelated = this.getDecorrelatedReference();
        double[] low = this.getLowReference();
        long[] z = new long[n];
        double[] zb = new double[n];
        double[] y = new double[n];
        int[] path = new int[n];
        for (int i = 0; i < n; ++i) {
            path[i] = n - 1;
        }
        double[] step = new double[n];
        double[] dist = new double[n + 1];
        double[] lS = new double[n * (n - 1) / 2];
        double[] dS = new double[n];
        double maxDist = Double.POSITIVE_INFINITY;
        int count = 0;
        boolean endSearch = false;
        int ulevel = 0;
        int k0 = maxSolutions == 1 ? 1 : 0;
        zb[n - 1] = ((double[])decorrelated.clone())[n - 1];
        z[n - 1] = (long)FastMath.rint((double)zb[n - 1]);
        y[n - 1] = zb[n - 1] - (double)z[n - 1];
        step[n - 1] = this.sign(y[n - 1]);
        int k = n - 1;
        block1: while (!endSearch) {
            for (int i = ulevel; i <= k - 1; ++i) {
                path[i] = k;
            }
            for (int j = ulevel - 1; j >= 0 && path[j] < k; --j) {
                path[j] = k;
            }
            double newDist = dist[k] + y[k] * y[k] / diag[k];
            while (newDist < maxDist) {
                if (k != 0) {
                    dist[--k] = newDist;
                    for (int j = path[k]; j > k; --j) {
                        if (j - 1 == k) {
                            dS[k] = lS[this.lIndex(j, k)] - y[j] * low[this.lIndex(j, k)];
                            continue;
                        }
                        lS[this.lIndex((int)(j - 1), (int)k)] = lS[this.lIndex(j, k)] - y[j] * low[this.lIndex(j, k)];
                    }
                    zb[k] = decorrelated[k] + dS[k];
                    z[k] = (long)FastMath.rint((double)zb[k]);
                    y[k] = zb[k] - (double)z[k];
                    step[k] = this.sign(y[k]);
                } else {
                    if (count < maxSolutions - 1) {
                        this.addSolution(z, newDist);
                        ++count;
                    } else if (count == maxSolutions - 1) {
                        this.addSolution(z, newDist);
                        maxDist = this.getMaxDistance();
                        ++count;
                    } else {
                        this.removeSolution();
                        this.addSolution(z, newDist);
                        maxDist = this.getMaxDistance();
                    }
                    k = k0;
                    z[k] = z[k] + (long)step[k];
                    y[k] = zb[k] - (double)z[k];
                    step[k] = -step[k] - this.sign(step[k]);
                }
                newDist = dist[k] + y[k] * y[k] / diag[k];
            }
            ulevel = k;
            while (newDist >= maxDist) {
                if (k == n - 1) {
                    endSearch = true;
                    continue block1;
                }
                z[++k] = z[k] + (long)step[k];
                y[k] = zb[k] - (double)z[k];
                step[k] = -step[k] - this.sign(step[k]);
                newDist = dist[k] + y[k] * y[k] / diag[k];
            }
        }
    }

    @Override
    protected void inverseDecomposition() {
    }

    private int posMin(double[] D, int k) {
        int q = 0;
        double value = D[0];
        for (int i = 1; i <= k; ++i) {
            if (!(value > D[i])) continue;
            value = D[i];
            q = i;
        }
        return q;
    }

    private void set(double[] L, double[] D, int p) {
        int i;
        double d = D[p];
        double[] row = new double[p];
        for (i = 0; i < p; ++i) {
            row[i] = L[this.lIndex(p, i)];
        }
        for (i = 0; i < p; ++i) {
            for (int j = 0; j < i; ++j) {
                L[this.lIndex((int)i, (int)j)] = L[this.lIndex(i, j)] - row[i] * row[j] * d;
            }
            D[i] = D[i] - row[i] * row[i] * d;
        }
    }

    private void permRowThenCol(double[] L, double[] D, int p1, int p2) {
        double[] rowP1 = this.getRow(L, D, p1);
        double[] rowP2 = this.getRow(L, D, p2);
        if (p1 > p2) {
            int i;
            int j;
            for (j = 0; j < p2; ++j) {
                L[this.lIndex((int)p2, (int)j)] = rowP1[j];
            }
            D[p2] = rowP1[p2];
            for (j = 0; j < p1; ++j) {
                L[this.lIndex((int)p1, (int)j)] = rowP2[j];
            }
            D[p1] = rowP2[p1];
            double[] colP1 = this.getColPmax(L, D, rowP1, p2, p1);
            for (i = p1 + 1; i < D.length; ++i) {
                L[this.lIndex((int)i, (int)p1)] = L[this.lIndex(i, p2)];
            }
            D[p1] = L[this.lIndex(p1, p2)];
            for (i = p2 + 1; i < D.length; ++i) {
                L[this.lIndex((int)i, (int)p2)] = colP1[i];
            }
            D[p2] = colP1[p2];
        }
    }

    private double[] getRow(double[] L, double[] D, int pos) {
        int j;
        double[] row = new double[D.length];
        for (j = 0; j < pos; ++j) {
            row[j] = L[this.lIndex(pos, j)];
        }
        row[pos] = D[pos];
        for (j = pos + 1; j < D.length; ++j) {
            row[j] = L[this.lIndex(j, pos)];
        }
        return row;
    }

    private double[] getColPmax(double[] L, double[] D, double[] row, int pmin, int pmax) {
        int i;
        double[] col = new double[D.length];
        col[pmin] = row[pmax];
        for (i = pmin + 1; i < pmax; ++i) {
            col[i] = row[i];
        }
        col[pmax] = D[pmax];
        for (i = pmax + 1; i < D.length; ++i) {
            col[i] = L[this.lIndex(i, pmax)];
        }
        return col;
    }

    private void divide(double[] mat, double diag, int k) {
        for (int j = 0; j < k; ++j) {
            mat[this.lIndex((int)k, (int)j)] = mat[this.lIndex(k, j)] / diag;
        }
    }

    private void exchangeIntP1WithIntP2(int[] mat, int p1, int p2) {
        int[] Z = (int[])mat.clone();
        mat[p1] = Z[p2];
        mat[p2] = Z[p1];
    }

    private void exchangeDoubleP1WithDoubleP2(double[] mat, int p1, int p2) {
        double[] a = (double[])mat.clone();
        mat[p1] = a[p2];
        mat[p2] = a[p1];
    }

    protected double sign(double a) {
        return a <= 0.0 ? -1.0 : (a > 0.0 ? 1.0 : a);
    }
}

