/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.gnss;

import org.hipparchus.util.ArithmeticUtils;
import org.hipparchus.util.MathArrays;
import org.orekit.estimation.measurements.gnss.AbstractDualFrequencyCombination;
import org.orekit.estimation.measurements.gnss.CombinationType;
import org.orekit.gnss.Frequency;
import org.orekit.gnss.SatelliteSystem;

public class IonosphereFreeCombination
extends AbstractDualFrequencyCombination {
    IonosphereFreeCombination(SatelliteSystem system) {
        super(CombinationType.IONO_FREE, system);
    }

    @Override
    protected double getCombinedValue(double obs1, Frequency f1, double obs2, Frequency f2) {
        double ratioF1 = f1.getRatio();
        double ratioF2 = f2.getRatio();
        double ratioF1Sq = ratioF1 * ratioF1;
        double ratioF2Sq = ratioF2 * ratioF2;
        return MathArrays.linearCombination((double)ratioF1Sq, (double)obs1, (double)(-ratioF2Sq), (double)obs2) / (ratioF1Sq - ratioF2Sq);
    }

    @Override
    protected double getCombinedFrequency(Frequency f1, Frequency f2) {
        double ratioF1 = f1.getRatio();
        double ratioF2 = f2.getRatio();
        int ratioF1Int = (int)ratioF1;
        int ratioF2Int = (int)ratioF2;
        int k = ratioF1 - (double)ratioF1Int > 0.0 || ratioF2 - (double)ratioF2Int > 0.0 ? 1 : ArithmeticUtils.gcd((int)ratioF1Int, (int)ratioF2Int);
        return MathArrays.linearCombination((double)ratioF1, (double)ratioF1, (double)(-ratioF2), (double)ratioF2) * (10.229999999999999 / (double)k);
    }
}

