/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.gnss;

import java.util.Arrays;
import org.hipparchus.analysis.differentiation.Gradient;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurementBase;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.estimation.measurements.gnss.AbstractInterSatellitesMeasurement;
import org.orekit.estimation.measurements.gnss.AmbiguityCache;
import org.orekit.estimation.measurements.gnss.AmbiguityDriver;
import org.orekit.estimation.measurements.gnss.OnBoardCommonParametersWithDerivatives;
import org.orekit.estimation.measurements.gnss.OnBoardCommonParametersWithoutDerivatives;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeSpanMap;
import org.orekit.utils.TimeStampedPVCoordinates;

public class InterSatellitesPhase
extends AbstractInterSatellitesMeasurement<InterSatellitesPhase> {
    public static final String MEASUREMENT_TYPE = "InterSatellitesPhase";
    @Deprecated
    public static final String AMBIGUITY_NAME = "ambiguity";
    private final AmbiguityDriver ambiguityDriver;
    private final double wavelength;

    @Deprecated
    public InterSatellitesPhase(ObservableSatellite local, ObservableSatellite remote, AbsoluteDate date, double phase, double wavelength, double sigma, double baseWeight) {
        this(local, remote, date, phase, wavelength, sigma, baseWeight, AmbiguityCache.DEFAULT_CACHE);
    }

    public InterSatellitesPhase(ObservableSatellite local, ObservableSatellite remote, AbsoluteDate date, double phase, double wavelength, double sigma, double baseWeight, AmbiguityCache cache) {
        super(date, phase, sigma, baseWeight, local, remote);
        this.ambiguityDriver = cache.getAmbiguity(remote.getName(), local.getName(), wavelength);
        this.addParameterDriver(this.ambiguityDriver);
        this.wavelength = wavelength;
    }

    public double getWavelength() {
        return this.wavelength;
    }

    public ParameterDriver getAmbiguityDriver() {
        return this.ambiguityDriver;
    }

    @Override
    protected EstimatedMeasurementBase<InterSatellitesPhase> theoreticalEvaluationWithoutDerivatives(int iteration, int evaluation, SpacecraftState[] states) {
        OnBoardCommonParametersWithoutDerivatives common = this.computeCommonParametersWithout(states, false);
        EstimatedMeasurementBase<InterSatellitesPhase> estimatedPhase = new EstimatedMeasurementBase<InterSatellitesPhase>(this, iteration, evaluation, new SpacecraftState[]{common.getState(), states[1]}, new TimeStampedPVCoordinates[]{common.getRemotePV(), common.getTransitPV()});
        double cOverLambda = 2.99792458E8 / this.wavelength;
        double ambiguity = this.ambiguityDriver.getValue(common.getState().getDate());
        double phase = (common.getTauD() + common.getLocalOffset() - common.getRemoteOffset()) * cOverLambda + ambiguity;
        estimatedPhase.setEstimatedValue(phase);
        return estimatedPhase;
    }

    @Override
    protected EstimatedMeasurement<InterSatellitesPhase> theoreticalEvaluation(int iteration, int evaluation, SpacecraftState[] states) {
        OnBoardCommonParametersWithDerivatives common = this.computeCommonParametersWith(states, false);
        EstimatedMeasurement<InterSatellitesPhase> estimatedPhase = new EstimatedMeasurement<InterSatellitesPhase>(this, iteration, evaluation, new SpacecraftState[]{common.getState(), states[1]}, new TimeStampedPVCoordinates[]{common.getRemotePV().toTimeStampedPVCoordinates(), common.getTransitPV().toTimeStampedPVCoordinates()});
        double cOverLambda = 2.99792458E8 / this.wavelength;
        Gradient ambiguity = this.ambiguityDriver.getValue(common.getTauD().getFreeParameters(), common.getIndices(), common.getState().getDate());
        Gradient phase = common.getTauD().add(common.getLocalOffset()).subtract(common.getRemoteOffset()).multiply(cOverLambda).add(ambiguity);
        estimatedPhase.setEstimatedValue(phase.getValue());
        double[] derivatives = phase.getGradient();
        estimatedPhase.setStateDerivatives(0, new double[][]{Arrays.copyOfRange(derivatives, 0, 6)});
        estimatedPhase.setStateDerivatives(1, new double[][]{Arrays.copyOfRange(derivatives, 6, 12)});
        for (ParameterDriver driver : this.getParametersDrivers()) {
            for (TimeSpanMap.Span<String> span = driver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                Integer index = common.getIndices().get(span.getData());
                if (index == null) continue;
                estimatedPhase.setParameterDerivatives(driver, span.getStart(), derivatives[index]);
            }
        }
        return estimatedPhase;
    }
}

