/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.gnss;

import java.util.Arrays;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.geometry.euclidean.threed.FieldVector3D;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.orekit.estimation.measurements.EstimatedMeasurement;
import org.orekit.estimation.measurements.EstimatedMeasurementBase;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.estimation.measurements.gnss.AbstractInterSatellitesMeasurement;
import org.orekit.estimation.measurements.gnss.OnBoardCommonParametersWithDerivatives;
import org.orekit.estimation.measurements.gnss.OnBoardCommonParametersWithoutDerivatives;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeSpanMap;
import org.orekit.utils.TimeStampedPVCoordinates;

public class InterSatellitesOneWayRangeRate
extends AbstractInterSatellitesMeasurement<InterSatellitesOneWayRangeRate> {
    public static final String MEASUREMENT_TYPE = "InterSatellitesOneWayRangeRate";

    public InterSatellitesOneWayRangeRate(ObservableSatellite local, ObservableSatellite remote, AbsoluteDate date, double rangeRate, double sigma, double baseWeight) {
        super(date, rangeRate, sigma, baseWeight, local, remote);
    }

    @Override
    protected EstimatedMeasurementBase<InterSatellitesOneWayRangeRate> theoreticalEvaluationWithoutDerivatives(int iteration, int evaluation, SpacecraftState[] states) {
        OnBoardCommonParametersWithoutDerivatives common = this.computeCommonParametersWithout(states, false);
        EstimatedMeasurementBase<InterSatellitesOneWayRangeRate> estimatedPhase = new EstimatedMeasurementBase<InterSatellitesOneWayRangeRate>(this, iteration, evaluation, new SpacecraftState[]{common.getState(), states[1]}, new TimeStampedPVCoordinates[]{common.getRemotePV(), common.getTransitPV()});
        PVCoordinates delta = new PVCoordinates(common.getRemotePV(), (PVCoordinates)common.getTransitPV());
        double rangeRate = Vector3D.dotProduct((Vector3D)delta.getVelocity(), (Vector3D)((Vector3D)delta.getPosition().normalize())) + 2.99792458E8 * (common.getLocalRate() - common.getRemoteRate());
        estimatedPhase.setEstimatedValue(rangeRate);
        return estimatedPhase;
    }

    @Override
    protected EstimatedMeasurement<InterSatellitesOneWayRangeRate> theoreticalEvaluation(int iteration, int evaluation, SpacecraftState[] states) {
        OnBoardCommonParametersWithDerivatives common = this.computeCommonParametersWith(states, false);
        EstimatedMeasurement<InterSatellitesOneWayRangeRate> estimatedPhase = new EstimatedMeasurement<InterSatellitesOneWayRangeRate>(this, iteration, evaluation, new SpacecraftState[]{common.getState(), states[1]}, new TimeStampedPVCoordinates[]{common.getRemotePV().toTimeStampedPVCoordinates(), common.getTransitPV().toTimeStampedPVCoordinates()});
        FieldPVCoordinates<Gradient> delta = new FieldPVCoordinates<Gradient>(common.getRemotePV(), common.getTransitPV());
        Gradient rangeRate = ((Gradient)FieldVector3D.dotProduct(delta.getVelocity(), (FieldVector3D)delta.getPosition().normalize())).add(common.getLocalRate().subtract(common.getRemoteRate()).multiply(2.99792458E8));
        estimatedPhase.setEstimatedValue(rangeRate.getValue());
        double[] derivatives = rangeRate.getGradient();
        estimatedPhase.setStateDerivatives(0, new double[][]{Arrays.copyOfRange(derivatives, 0, 6)});
        estimatedPhase.setStateDerivatives(1, new double[][]{Arrays.copyOfRange(derivatives, 6, 12)});
        for (ParameterDriver driver : this.getParametersDrivers()) {
            for (TimeSpanMap.Span<String> span = driver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                Integer index = common.getIndices().get(span.getData());
                if (index == null) continue;
                estimatedPhase.setParameterDerivatives(driver, span.getStart(), derivatives[index]);
            }
        }
        return estimatedPhase;
    }
}

