/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.gnss;

import org.hipparchus.linear.MatrixUtils;
import org.hipparchus.linear.QRDecomposer;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.special.Erf;
import org.hipparchus.util.FastMath;
import org.orekit.estimation.measurements.gnss.IntegerLeastSquareSolution;
import org.orekit.estimation.measurements.gnss.LambdaMethod;

public class IntegerBootstrapping
extends LambdaMethod {
    private double minProb;
    private boolean boostrapUse;
    private long[] a_B;
    private double p_aB;

    public IntegerBootstrapping(double prob) {
        this.minProb = prob;
    }

    @Override
    protected void discreteSearch() {
        this.boostrapUse = this.upperBoundProbabilitySuccess() > this.minProb;
        double[] diag = this.getDiagReference();
        double[] low = this.getLowReference();
        int n = diag.length;
        if (this.boostrapUse) {
            RealMatrix I = MatrixUtils.createRealIdentityMatrix((int)n);
            this.a_B = new long[n];
            RealMatrix L = this.getSymmetricMatrixFromLowPart(low);
            RealMatrix invL_I = new QRDecomposer(1.0E-10).decompose(L).getInverse().subtract(I);
            double[] decorrelated = this.getDecorrelatedReference();
            this.a_B[0] = (long)FastMath.rint((double)decorrelated[0]);
            for (int i = 1; i < this.a_B.length; ++i) {
                double a_b = 0.0;
                for (int j = 0; j < i; ++j) {
                    a_b += invL_I.getEntry(i, j) * (double)this.a_B[j];
                }
                this.a_B[i] = (long)FastMath.rint((double)(decorrelated[i] + a_b));
            }
            this.p_aB = this.bootstrappedSuccessRate(diag, this.a_B);
            this.boostrapUse = this.p_aB > this.minProb;
        }
    }

    @Override
    protected IntegerLeastSquareSolution[] recoverAmbiguities() {
        if (this.boostrapUse) {
            double[] diag = this.getDiagReference();
            int n = diag.length;
            int[] zInverseTransformation = this.getZInverseTransformationReference();
            long[] a = new long[n];
            for (int i = 0; i < n; ++i) {
                long ai = 0L;
                int l = this.zIndex(0, i);
                for (int j = 0; j < n; ++j) {
                    ai += (long)zInverseTransformation[l] * this.a_B[j];
                    l += n;
                }
                a[i] = ai;
            }
            this.a_B = a;
            IntegerLeastSquareSolution sol = new IntegerLeastSquareSolution(this.a_B, this.p_aB);
            return new IntegerLeastSquareSolution[]{sol};
        }
        return new IntegerLeastSquareSolution[0];
    }

    private RealMatrix getSymmetricMatrixFromLowPart(double[] l) {
        double[] diag = this.getDiagReference();
        int n = diag.length;
        RealMatrix L = MatrixUtils.createRealMatrix((int)n, (int)n);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                L.setEntry(i, j, l[this.lIndex(i, j)]);
            }
            L.setEntry(i, i, 1.0);
        }
        return L;
    }

    private double bootstrappedSuccessRate(double[] D, long[] aB) {
        double p = 2.0 * this.phi(1.0 / (2.0 * D[0]) - 1.0);
        for (int i = 1; i < D.length; ++i) {
            p *= 2.0 * this.phi(1.0 / (2.0 * D[i])) - 1.0;
        }
        return p;
    }

    private double phi(double x) {
        return 0.5 * (1.0 + Erf.erf((double)(x / FastMath.sqrt((double)2.0))));
    }

    private double upperBoundProbabilitySuccess() {
        double det = 1.0;
        double[] diag = this.getDiagReference();
        int n = diag.length;
        for (double d : diag) {
            det *= d;
        }
        double adop = FastMath.pow((double)det, (double)(1.0 / (2.0 * (double)n)));
        return FastMath.pow((double)(2.0 * this.phi(1.0 / (2.0 * adop)) - 1.0), (int)n);
    }
}

