/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.gnss;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hipparchus.fitting.PolynomialCurveFitter;
import org.hipparchus.fitting.WeightedObservedPoint;
import org.hipparchus.util.FastMath;
import org.orekit.estimation.measurements.gnss.AbstractCycleSlipDetector;
import org.orekit.estimation.measurements.gnss.CombinedObservationData;
import org.orekit.estimation.measurements.gnss.CombinedObservationDataSet;
import org.orekit.estimation.measurements.gnss.CycleSlipDetectorResults;
import org.orekit.estimation.measurements.gnss.GeometryFreeCombination;
import org.orekit.estimation.measurements.gnss.MeasurementCombinationFactory;
import org.orekit.files.rinex.observation.ObservationDataSet;
import org.orekit.gnss.Frequency;
import org.orekit.gnss.MeasurementType;
import org.orekit.gnss.SatelliteSystem;
import org.orekit.time.AbsoluteDate;

public class GeometryFreeCycleSlipDetector
extends AbstractCycleSlipDetector {
    private final double threshold;

    public GeometryFreeCycleSlipDetector(double dt, double threshold, int n) {
        super(dt, n);
        this.threshold = threshold;
    }

    @Override
    protected void manageData(ObservationDataSet observation) {
        int prn = observation.getSatellite().getPRN();
        AbsoluteDate date = observation.getDate();
        SatelliteSystem system = observation.getSatellite().getSystem();
        GeometryFreeCombination geometryFree = MeasurementCombinationFactory.getGeometryFreeCombination(system);
        CombinedObservationDataSet cods = geometryFree.combine(observation);
        ArrayList<CombinedObservationData> phasesGF = new ArrayList<CombinedObservationData>();
        for (CombinedObservationData cod : cods.getObservationData()) {
            if (Double.isNaN(cod.getValue()) || cod.getMeasurementType() != MeasurementType.CARRIER_PHASE) continue;
            phasesGF.add(cod);
        }
        for (CombinedObservationData cod : phasesGF) {
            String nameSat = this.setName(prn, observation.getSatellite().getSystem());
            Frequency frequency = cod.getUsedObservationData().get(0).getObservationType().getFrequency(system);
            boolean slip = this.cycleSlipDetection(nameSat, date, cod.getValue(), frequency);
            if (slip) continue;
            this.cycleSlipDataSet(nameSat, date, cod.getValue(), cod.getUsedObservationData().get(0).getObservationType().getFrequency(system));
        }
    }

    private boolean cycleSlipDetection(String nameSat, AbsoluteDate currentDate, double valueGF, Frequency frequency) {
        List<CycleSlipDetectorResults> data = this.getResults();
        List<Map<Frequency, AbstractCycleSlipDetector.DataForDetection>> stuff = this.getStuffReference();
        if (data != null) {
            for (CycleSlipDetectorResults resultGF : data) {
                if (resultGF.getSatelliteName().compareTo(nameSat) != 0 || !resultGF.getCycleSlipMap().containsKey(frequency)) continue;
                Map<Frequency, AbstractCycleSlipDetector.DataForDetection> values = stuff.get(data.indexOf(resultGF));
                AbstractCycleSlipDetector.DataForDetection dataForDetection = values.get(frequency);
                double deltaT = FastMath.abs((double)currentDate.durationFrom(dataForDetection.getFiguresReference()[dataForDetection.getWrite()].getDate()));
                if (deltaT > this.getMaxTimeBeetween2Measurement()) {
                    resultGF.addCycleSlipDate(frequency, currentDate);
                    dataForDetection.resetFigures(new AbstractCycleSlipDetector.SlipComputationData[this.getMinMeasurementNumber()], valueGF, currentDate);
                    resultGF.setDate(frequency, currentDate);
                    return true;
                }
                if (dataForDetection.getCanBeComputed() < this.getMinMeasurementNumber()) break;
                ArrayList<WeightedObservedPoint> xy = new ArrayList<WeightedObservedPoint>();
                for (int i = 0; i < this.getMinMeasurementNumber(); ++i) {
                    AbstractCycleSlipDetector.SlipComputationData current = dataForDetection.getFiguresReference()[i];
                    xy.add(new WeightedObservedPoint(1.0, current.getDate().durationFrom(currentDate), current.getValue()));
                }
                PolynomialCurveFitter fitting = PolynomialCurveFitter.create((int)2);
                if (!(FastMath.abs((double)(fitting.fit(xy)[0] - valueGF)) > this.threshold)) continue;
                resultGF.addCycleSlipDate(frequency, currentDate);
                dataForDetection.resetFigures(new AbstractCycleSlipDetector.SlipComputationData[this.getMinMeasurementNumber()], valueGF, currentDate);
                resultGF.setDate(frequency, currentDate);
                return true;
            }
        }
        return false;
    }
}

