/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.gnss;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.orekit.gnss.Frequency;
import org.orekit.time.AbsoluteDate;

public class CycleSlipDetectorResults {
    private String satellite;
    private Map<Frequency, AbsoluteDate> begin = new HashMap<Frequency, AbsoluteDate>();
    private Map<Frequency, AbsoluteDate> end = new HashMap<Frequency, AbsoluteDate>();
    private Map<Frequency, List<AbsoluteDate>> results = new HashMap<Frequency, List<AbsoluteDate>>();

    CycleSlipDetectorResults(String satellite, AbsoluteDate date, Frequency freq) {
        this.satellite = satellite;
        this.begin.put(freq, date);
        this.end.put(freq, date);
        this.results.put(freq, new ArrayList());
    }

    public String getSatelliteName() {
        return this.satellite;
    }

    public AbsoluteDate getEndDate(Frequency f) {
        return this.end.get(f);
    }

    public AbsoluteDate getBeginDate(Frequency f) {
        return this.begin.get(f);
    }

    public Map<Frequency, List<AbsoluteDate>> getCycleSlipMap() {
        return this.results;
    }

    void addCycleSlipDate(Frequency f, AbsoluteDate date) {
        List<AbsoluteDate> newList = this.results.get(f);
        newList.add(date);
        this.results.put(f, newList);
    }

    void addAtOtherFrequency(Frequency f, AbsoluteDate date) {
        this.begin.put(f, date);
        this.end.put(f, date);
        this.results.put(f, new ArrayList());
    }

    void setDate(Frequency f, AbsoluteDate date) {
        this.end.put(f, date);
    }
}

