/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.gnss;

import java.util.Collections;
import java.util.List;
import org.orekit.estimation.measurements.gnss.CombinedObservationData;
import org.orekit.gnss.SatelliteSystem;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeStamped;

public class CombinedObservationDataSet
implements TimeStamped {
    private final SatelliteSystem satelliteSystem;
    private final int prnNumber;
    private final AbsoluteDate tObs;
    private final List<CombinedObservationData> observationData;
    private final double rcvrClkOffset;

    public CombinedObservationDataSet(SatelliteSystem satelliteSystem, int prnNumber, AbsoluteDate tObs, double rcvrClkOffset, List<CombinedObservationData> observationData) {
        this.satelliteSystem = satelliteSystem;
        this.prnNumber = prnNumber;
        this.tObs = tObs;
        this.observationData = observationData;
        this.rcvrClkOffset = rcvrClkOffset;
    }

    public SatelliteSystem getSatelliteSystem() {
        return this.satelliteSystem;
    }

    public int getPrnNumber() {
        return this.prnNumber;
    }

    @Override
    public AbsoluteDate getDate() {
        return this.tObs;
    }

    public List<CombinedObservationData> getObservationData() {
        return Collections.unmodifiableList(this.observationData);
    }

    public double getRcvrClkOffset() {
        return this.rcvrClkOffset;
    }
}

