/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.gnss;

import java.util.List;
import org.orekit.estimation.measurements.gnss.CombinationType;
import org.orekit.files.rinex.observation.ObservationData;
import org.orekit.gnss.MeasurementType;

public class CombinedObservationData {
    private final CombinationType combinationType;
    private final MeasurementType measurementType;
    private final double value;
    private final double combinedFrequency;
    private final List<ObservationData> usedData;

    @Deprecated
    public CombinedObservationData(CombinationType combinationType, MeasurementType measurementType, double combinedValue, double combinedFrequencyMHz, List<ObservationData> usedData) {
        this(combinedValue, combinedFrequencyMHz * 1000000.0, combinationType, measurementType, usedData);
    }

    public CombinedObservationData(double combinedValue, double combinedFrequency, CombinationType combinationType, MeasurementType measurementType, List<ObservationData> usedData) {
        this.combinationType = combinationType;
        this.measurementType = measurementType;
        this.value = combinedValue;
        this.combinedFrequency = combinedFrequency;
        this.usedData = usedData;
    }

    public double getValue() {
        return this.value;
    }

    public double getCombinedFrequency() {
        return this.combinedFrequency;
    }

    @Deprecated
    public double getCombinedMHzFrequency() {
        return this.getCombinedFrequency() / 1000000.0;
    }

    public CombinationType getCombinationType() {
        return this.combinationType;
    }

    public MeasurementType getMeasurementType() {
        return this.measurementType;
    }

    public List<ObservationData> getUsedObservationData() {
        return this.usedData;
    }
}

