/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.gnss;

import java.util.Locale;
import org.hipparchus.util.FastMath;
import org.orekit.utils.ParameterDriver;

public class AmbiguityDriver
extends ParameterDriver {
    public static final String PREFIX = "ambiguity";
    private static final double AMBIGUITY_SCALE = FastMath.scalb((double)1.0, (int)26);
    private final String emitter;
    private final String receiver;
    private final double wavelength;

    public AmbiguityDriver(String emitter, String receiver, double wavelength) {
        super(String.format(Locale.US, "%s-%s-%s-%.2f", PREFIX, emitter, receiver, 2.99792458E8 / (wavelength * 1.023E7)), 0.0, AMBIGUITY_SCALE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.emitter = emitter;
        this.receiver = receiver;
        this.wavelength = wavelength;
    }

    public String getEmitter() {
        return this.emitter;
    }

    public String getReceiver() {
        return this.receiver;
    }

    public double getWavelength() {
        return this.wavelength;
    }
}

