/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.gnss;

import java.util.Collections;
import java.util.List;
import org.hipparchus.geometry.Vector;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.MathUtils;
import org.orekit.estimation.measurements.EstimatedMeasurementBase;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.estimation.measurements.gnss.Dipole;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeStampedPVCoordinates;

public abstract class AbstractWindUp<T extends ObservedMeasurement<T>>
implements EstimationModifier<T> {
    private final Dipole emitter;
    private final Dipole receiver;
    private double angularWindUp;

    protected AbstractWindUp(Dipole emitter, Dipole receiver) {
        this.emitter = emitter;
        this.receiver = receiver;
        this.angularWindUp = 0.0;
    }

    @Override
    public List<ParameterDriver> getParametersDrivers() {
        return Collections.emptyList();
    }

    protected abstract Rotation emitterToInert(EstimatedMeasurementBase<T> var1);

    protected abstract Rotation receiverToInert(EstimatedMeasurementBase<T> var1);

    @Override
    public void modifyWithoutDerivatives(EstimatedMeasurementBase<T> estimated) {
        TimeStampedPVCoordinates[] participants = estimated.getParticipants();
        Vector3D los = (Vector3D)participants[1].getPosition().subtract((Vector)participants[0].getPosition()).normalize();
        Rotation receiverToInert = this.receiverToInert(estimated);
        Vector3D iReceiver = receiverToInert.applyTo(this.receiver.getPrimary());
        Vector3D jReceiver = receiverToInert.applyTo(this.receiver.getSecondary());
        Vector3D dReceiver = new Vector3D(1.0, iReceiver, -Vector3D.dotProduct((Vector3D)iReceiver, (Vector3D)los), los).add((Vector)Vector3D.crossProduct((Vector3D)los, (Vector3D)jReceiver));
        Rotation emitterToInert = this.emitterToInert(estimated);
        Vector3D iEmitter = emitterToInert.applyTo(this.emitter.getPrimary());
        Vector3D jEmitter = emitterToInert.applyTo(this.emitter.getSecondary());
        Vector3D dEmitter = new Vector3D(1.0, iEmitter, -Vector3D.dotProduct((Vector3D)iEmitter, (Vector3D)los), los).subtract((Vector)Vector3D.crossProduct((Vector3D)los, (Vector3D)jEmitter));
        double correction = FastMath.copySign((double)Vector3D.angle((Vector3D)dEmitter, (Vector3D)dReceiver), (double)Vector3D.dotProduct((Vector3D)los, (Vector3D)Vector3D.crossProduct((Vector3D)dEmitter, (Vector3D)dReceiver)));
        this.angularWindUp = MathUtils.normalizeAngle((double)correction, (double)this.angularWindUp);
        estimated.modifyEstimatedValue(this, estimated.getEstimatedValue()[0] + this.angularWindUp / (Math.PI * 2));
    }
}

