/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.gnss;

import java.util.ArrayList;
import java.util.Arrays;
import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.estimation.measurements.gnss.CombinationType;
import org.orekit.estimation.measurements.gnss.CombinedObservationData;
import org.orekit.estimation.measurements.gnss.CombinedObservationDataSet;
import org.orekit.estimation.measurements.gnss.MeasurementCombination;
import org.orekit.files.rinex.observation.ObservationData;
import org.orekit.files.rinex.observation.ObservationDataSet;
import org.orekit.gnss.Frequency;
import org.orekit.gnss.MeasurementType;
import org.orekit.gnss.ObservationType;
import org.orekit.gnss.SatelliteSystem;

public abstract class AbstractSingleFrequencyCombination
implements MeasurementCombination {
    private final CombinationType type;
    private final SatelliteSystem system;

    protected AbstractSingleFrequencyCombination(CombinationType type, SatelliteSystem system) {
        this.type = type;
        this.system = system;
    }

    @Override
    public String getName() {
        return this.type.getName();
    }

    @Override
    public CombinedObservationDataSet combine(ObservationDataSet observations) {
        ArrayList<ObservationData> pseudoRanges = new ArrayList<ObservationData>();
        ArrayList<ObservationData> phases = new ArrayList<ObservationData>();
        for (ObservationData od : observations.getObservationData()) {
            if (Double.isNaN(od.getValue())) continue;
            if (od.getObservationType().getMeasurementType() == MeasurementType.PSEUDO_RANGE) {
                pseudoRanges.add(od);
                continue;
            }
            if (od.getObservationType().getMeasurementType() != MeasurementType.CARRIER_PHASE) continue;
            phases.add(od);
        }
        ArrayList<CombinedObservationData> combined = new ArrayList<CombinedObservationData>();
        for (ObservationData phase : phases) {
            for (ObservationData pseudoRange : pseudoRanges) {
                if (phase.getObservationType().getFrequency(this.system) != pseudoRange.getObservationType().getFrequency(this.system) || phase.getObservationType().getSignalCode() != pseudoRange.getObservationType().getSignalCode()) continue;
                combined.add(this.combine(phase, pseudoRange));
            }
        }
        return new CombinedObservationDataSet(observations.getSatellite().getSystem(), observations.getSatellite().getPRN(), observations.getDate(), observations.getRcvrClkOffset(), combined);
    }

    public CombinedObservationData combine(ObservationData phase, ObservationData pseudoRange) {
        MeasurementType measType2;
        Frequency freq2;
        ObservationType obsType1 = phase.getObservationType();
        ObservationType obsType2 = pseudoRange.getObservationType();
        Frequency freq1 = obsType1.getFrequency(this.system);
        if (freq1 != (freq2 = obsType2.getFrequency(this.system))) {
            throw new OrekitException((Localizable)OrekitMessages.INCOMPATIBLE_FREQUENCIES_FOR_COMBINATION_OF_MEASUREMENTS, freq1, freq2, this.getName());
        }
        MeasurementType measType1 = obsType1.getMeasurementType();
        if (measType1 == (measType2 = obsType2.getMeasurementType())) {
            throw new OrekitException((Localizable)OrekitMessages.INVALID_MEASUREMENT_TYPES_FOR_COMBINATION_OF_MEASUREMENTS, new Object[]{measType1, measType2, this.getName()});
        }
        double f = freq1.getMHzFrequency();
        double combinedValue = this.getCombinedValue(phase.getValue(), pseudoRange.getValue());
        return new CombinedObservationData(CombinationType.PHASE_MINUS_CODE, MeasurementType.COMBINED_RANGE_PHASE, combinedValue, f, Arrays.asList(phase, pseudoRange));
    }

    protected abstract double getCombinedValue(double var1, double var3);
}

