/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.gnss;

import java.util.Collections;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.differentiation.Gradient;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.estimation.measurements.QuadraticClockModel;
import org.orekit.estimation.measurements.gnss.AbstractOnBoardMeasurement;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public abstract class AbstractOneWayGNSSMeasurement<T extends ObservedMeasurement<T>>
extends AbstractOnBoardMeasurement<T> {
    private final PVCoordinatesProvider remotePV;
    private final QuadraticClockModel remoteClock;

    public AbstractOneWayGNSSMeasurement(PVCoordinatesProvider remotePV, QuadraticClockModel remoteClock, AbsoluteDate date, double range, double sigma, double baseWeight, ObservableSatellite local) {
        super(date, range, sigma, baseWeight, Collections.singletonList(local));
        this.addParameterDriver(local.getClockOffsetDriver());
        this.addParameterDriver(local.getClockDriftDriver());
        this.addParameterDriver(local.getClockAccelerationDriver());
        this.remotePV = remotePV;
        this.remoteClock = remoteClock;
    }

    @Override
    protected PVCoordinatesProvider getRemotePV(SpacecraftState[] states) {
        return this.remotePV;
    }

    @Override
    protected QuadraticClockModel getRemoteClock() {
        return this.remoteClock;
    }

    @Override
    protected FieldPVCoordinatesProvider<Gradient> getRemotePV(SpacecraftState[] states, int freeParameters) {
        return (date, frame) -> {
            AbsoluteDate dateBase = date.toAbsoluteDate();
            TimeStampedPVCoordinates pvBase = this.remotePV.getPVCoordinates(dateBase, frame);
            TimeStampedFieldPVCoordinates pvWithoutDerivatives = new TimeStampedFieldPVCoordinates(date.getField(), pvBase);
            Gradient zeroWithDerivatives = (Gradient)date.durationFrom(dateBase);
            return pvWithoutDerivatives.shiftedBy((CalculusFieldElement)zeroWithDerivatives);
        };
    }
}

