/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.gnss;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.differentiation.Gradient;
import org.hipparchus.analysis.differentiation.GradientField;
import org.orekit.estimation.measurements.AbstractMeasurement;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.estimation.measurements.QuadraticClockModel;
import org.orekit.estimation.measurements.QuadraticFieldClockModel;
import org.orekit.estimation.measurements.gnss.OnBoardCommonParametersWithDerivatives;
import org.orekit.estimation.measurements.gnss.OnBoardCommonParametersWithoutDerivatives;
import org.orekit.frames.Frame;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.ClockOffset;
import org.orekit.time.FieldAbsoluteDate;
import org.orekit.time.FieldClockOffset;
import org.orekit.time.FieldTimeShiftable;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.ParameterDriver;
import org.orekit.utils.TimeSpanMap;
import org.orekit.utils.TimeStampedFieldPVCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public abstract class AbstractOnBoardMeasurement<T extends ObservedMeasurement<T>>
extends AbstractMeasurement<T> {
    public AbstractOnBoardMeasurement(AbsoluteDate date, double observed, double sigma, double baseWeight, List<ObservableSatellite> satellites) {
        super(date, observed, sigma, baseWeight, satellites);
        satellites.forEach(s -> {
            this.addParameterDriver(s.getClockOffsetDriver());
            this.addParameterDriver(s.getClockDriftDriver());
            this.addParameterDriver(s.getClockAccelerationDriver());
        });
    }

    protected abstract QuadraticClockModel getRemoteClock();

    protected abstract PVCoordinatesProvider getRemotePV(SpacecraftState[] var1);

    protected abstract FieldPVCoordinatesProvider<Gradient> getRemotePV(SpacecraftState[] var1, int var2);

    protected QuadraticFieldClockModel<Gradient> getRemoteClock(int freeParameters, Map<String, Integer> indices) {
        return this.getRemoteClock().toGradientModel(freeParameters, indices, this.getDate());
    }

    protected OnBoardCommonParametersWithoutDerivatives computeCommonParametersWithout(SpacecraftState[] states, boolean clockOffsetAlreadyApplied) {
        Frame frame = states[0].getFrame();
        TimeStampedPVCoordinates pvaLocal = states[0].getPVCoordinates(frame);
        ClockOffset localClock = this.getSatellites().get(0).getQuadraticClockModel().getOffset(this.getDate());
        double localClockOffset = localClock.getOffset();
        double localClockRate = localClock.getRate();
        PVCoordinatesProvider remotePV = this.getRemotePV(states);
        AbsoluteDate arrivalDate = clockOffsetAlreadyApplied ? this.getDate() : this.getDate().shiftedBy(-localClockOffset);
        double deltaT = arrivalDate.durationFrom(states[0]);
        TimeStampedPVCoordinates pvaDownlink = pvaLocal.shiftedBy(deltaT);
        double tauD = AbstractOnBoardMeasurement.signalTimeOfFlight(remotePV, arrivalDate, pvaDownlink.getPosition(), arrivalDate, frame);
        AbsoluteDate emissionDate = arrivalDate.shiftedBy(-tauD);
        ClockOffset remoteClock = this.getRemoteClock().getOffset(emissionDate);
        double remoteClockOffset = remoteClock.getOffset();
        double remoteClockRate = remoteClock.getRate();
        return new OnBoardCommonParametersWithoutDerivatives(states[0], localClockOffset, localClockRate, remoteClockOffset, remoteClockRate, tauD, pvaDownlink, remotePV.getPVCoordinates(emissionDate, frame));
    }

    protected OnBoardCommonParametersWithDerivatives computeCommonParametersWith(SpacecraftState[] states, boolean clockOffsetAlreadyApplied) {
        Frame frame = states[0].getFrame();
        int nbEstimatedParams = 6 * states.length;
        HashMap<String, Integer> parameterIndices = new HashMap<String, Integer>();
        for (ParameterDriver measurementDriver : this.getParametersDrivers()) {
            if (!measurementDriver.isSelected()) continue;
            for (TimeSpanMap.Span<String> span = measurementDriver.getNamesSpanMap().getFirstSpan(); span != null; span = span.next()) {
                parameterIndices.put(span.getData(), nbEstimatedParams++);
            }
        }
        FieldAbsoluteDate gDate = new FieldAbsoluteDate(GradientField.getField((int)nbEstimatedParams), this.getDate());
        TimeStampedFieldPVCoordinates<Gradient> pvaLocal = AbstractOnBoardMeasurement.getCoordinates(states[0], 0, nbEstimatedParams);
        QuadraticFieldClockModel<Gradient> localClock = this.getSatellites().get(0).getQuadraticClockModel().toGradientModel(nbEstimatedParams, parameterIndices, this.getDate());
        FieldClockOffset<Gradient> localClockOffset = localClock.getOffset(gDate);
        FieldPVCoordinatesProvider<Gradient> remotePV = this.getRemotePV(states, nbEstimatedParams);
        FieldAbsoluteDate arrivalDate = clockOffsetAlreadyApplied ? gDate : gDate.shiftedBy((CalculusFieldElement)localClockOffset.getOffset().negate());
        Gradient deltaT = (Gradient)arrivalDate.durationFrom(states[0].getDate());
        FieldPVCoordinates pvaDownlink = pvaLocal.shiftedBy((CalculusFieldElement)deltaT);
        Gradient tauD = AbstractOnBoardMeasurement.signalTimeOfFlight(remotePV, arrivalDate, pvaDownlink.getPosition(), arrivalDate, frame);
        FieldTimeShiftable emissionDate = arrivalDate.shiftedBy((CalculusFieldElement)tauD.negate());
        QuadraticFieldClockModel<Gradient> remoteClock = this.getRemoteClock(nbEstimatedParams, parameterIndices);
        FieldClockOffset<Gradient> remoteClockOffset = remoteClock.getOffset((FieldAbsoluteDate<Gradient>)emissionDate);
        return new OnBoardCommonParametersWithDerivatives(states[0], parameterIndices, localClockOffset.getOffset(), localClockOffset.getRate(), remoteClockOffset.getOffset(), remoteClockOffset.getRate(), tauD, (TimeStampedFieldPVCoordinates<Gradient>)pvaDownlink, remotePV.getPVCoordinates((FieldAbsoluteDate<Gradient>)emissionDate, frame));
    }
}

