/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.gnss;

import java.util.Arrays;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.analysis.differentiation.Gradient;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.estimation.measurements.QuadraticClockModel;
import org.orekit.estimation.measurements.gnss.AbstractOnBoardMeasurement;
import org.orekit.propagation.SpacecraftState;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.FieldPVCoordinates;
import org.orekit.utils.FieldPVCoordinatesProvider;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.ShiftingPVCoordinatesProvider;
import org.orekit.utils.TimeStampedFieldPVCoordinates;

public abstract class AbstractInterSatellitesMeasurement<T extends ObservedMeasurement<T>>
extends AbstractOnBoardMeasurement<T> {
    public AbstractInterSatellitesMeasurement(AbsoluteDate date, double observed, double sigma, double baseWeight, ObservableSatellite local, ObservableSatellite remote) {
        super(date, observed, sigma, baseWeight, Arrays.asList(local, remote));
    }

    @Override
    protected PVCoordinatesProvider getRemotePV(SpacecraftState[] states) {
        return new ShiftingPVCoordinatesProvider(states[1].getPVCoordinates(), states[1].getFrame());
    }

    @Override
    protected QuadraticClockModel getRemoteClock() {
        return this.getSatellites().get(1).getQuadraticClockModel();
    }

    @Override
    protected FieldPVCoordinatesProvider<Gradient> getRemotePV(SpacecraftState[] states, int freeParameters) {
        return (date, frame) -> {
            TimeStampedFieldPVCoordinates<Gradient> pv0 = AbstractInterSatellitesMeasurement.getCoordinates(states[1], 6, freeParameters);
            FieldPVCoordinates shifted = pv0.shiftedBy((CalculusFieldElement)((Gradient)date.durationFrom(states[1].getDate())));
            return states[1].getFrame().getTransformTo(frame, states[1].getDate()).transformPVCoordinates(shifted);
        };
    }
}

