/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.gnss;

import java.util.ArrayList;
import java.util.Arrays;
import org.hipparchus.exception.Localizable;
import org.orekit.errors.OrekitException;
import org.orekit.errors.OrekitMessages;
import org.orekit.estimation.measurements.gnss.CombinationType;
import org.orekit.estimation.measurements.gnss.CombinedObservationData;
import org.orekit.estimation.measurements.gnss.CombinedObservationDataSet;
import org.orekit.estimation.measurements.gnss.MeasurementCombination;
import org.orekit.files.rinex.observation.ObservationData;
import org.orekit.files.rinex.observation.ObservationDataSet;
import org.orekit.gnss.Frequency;
import org.orekit.gnss.MeasurementType;
import org.orekit.gnss.ObservationType;
import org.orekit.gnss.SatelliteSystem;

public abstract class AbstractDualFrequencyCombination
implements MeasurementCombination {
    public static final double MHZ_TO_HZ = 1000000.0;
    private final CombinationType type;
    private final SatelliteSystem system;

    protected AbstractDualFrequencyCombination(CombinationType type, SatelliteSystem system) {
        this.type = type;
        this.system = system;
    }

    @Override
    public String getName() {
        return this.type.getName();
    }

    public CombinedObservationData combine(ObservationData od1, ObservationData od2) {
        double combinedValue;
        MeasurementType measType2;
        Frequency freq2;
        ObservationType obsType1 = od1.getObservationType();
        ObservationType obsType2 = od2.getObservationType();
        Frequency freq1 = obsType1.getFrequency(this.system);
        if (freq1 == (freq2 = obsType2.getFrequency(this.system))) {
            throw new OrekitException((Localizable)OrekitMessages.INCOMPATIBLE_FREQUENCIES_FOR_COMBINATION_OF_MEASUREMENTS, freq1, freq2, this.getName());
        }
        MeasurementType measType1 = obsType1.getMeasurementType();
        if (measType1 != (measType2 = obsType2.getMeasurementType())) {
            throw new OrekitException((Localizable)OrekitMessages.INVALID_MEASUREMENT_TYPES_FOR_COMBINATION_OF_MEASUREMENTS, new Object[]{measType1, measType2, this.getName()});
        }
        double combinedFrequency = this.getCombinedFrequency(freq1, freq2);
        if (obsType1.getMeasurementType() == MeasurementType.CARRIER_PHASE && !Double.isNaN(combinedFrequency)) {
            double obs1Meters = od1.getValue() * freq1.getWavelength();
            double obs2Meters = od2.getValue() * freq2.getWavelength();
            combinedValue = this.getCombinedValue(obs1Meters, freq1, obs2Meters, freq2) * (combinedFrequency * 1000000.0) / 2.99792458E8;
        } else {
            combinedValue = this.getCombinedValue(od1.getValue(), freq1, od2.getValue(), freq2);
        }
        return new CombinedObservationData(this.type, measType1, combinedValue, combinedFrequency, Arrays.asList(od1, od2));
    }

    @Override
    public CombinedObservationDataSet combine(ObservationDataSet observations) {
        boolean combine;
        int j;
        int i;
        ArrayList<ObservationData> pseudoRanges = new ArrayList<ObservationData>();
        ArrayList<ObservationData> phases = new ArrayList<ObservationData>();
        for (ObservationData od : observations.getObservationData()) {
            if (Double.isNaN(od.getValue())) continue;
            if (od.getObservationType().getMeasurementType() == MeasurementType.PSEUDO_RANGE) {
                pseudoRanges.add(od);
                continue;
            }
            if (od.getObservationType().getMeasurementType() != MeasurementType.CARRIER_PHASE) continue;
            phases.add(od);
        }
        ArrayList<CombinedObservationData> combined = new ArrayList<CombinedObservationData>();
        for (i = 0; i < pseudoRanges.size() - 1; ++i) {
            for (j = 1; j < pseudoRanges.size(); ++j) {
                combine = this.isCombinationPossible((ObservationData)pseudoRanges.get(i), (ObservationData)pseudoRanges.get(j));
                if (!combine) continue;
                combined.add(this.combine((ObservationData)pseudoRanges.get(i), (ObservationData)pseudoRanges.get(j)));
            }
        }
        for (i = 0; i < phases.size() - 1; ++i) {
            for (j = 1; j < phases.size(); ++j) {
                combine = this.isCombinationPossible((ObservationData)phases.get(i), (ObservationData)phases.get(j));
                if (!combine) continue;
                combined.add(this.combine((ObservationData)phases.get(i), (ObservationData)phases.get(j)));
            }
        }
        return new CombinedObservationDataSet(observations.getSatellite().getSystem(), observations.getSatellite().getPRN(), observations.getDate(), observations.getRcvrClkOffset(), combined);
    }

    protected abstract double getCombinedValue(double var1, Frequency var3, double var4, Frequency var6);

    protected abstract double getCombinedFrequency(Frequency var1, Frequency var2);

    private boolean isCombinationPossible(ObservationData data1, ObservationData data2) {
        ObservationType obsType1 = data1.getObservationType();
        ObservationType obsType2 = data2.getObservationType();
        return obsType1.getFrequency(this.system) != obsType2.getFrequency(this.system) && obsType1.getSignalCode() == obsType2.getSignalCode();
    }
}

