/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.generation;

import java.util.Map;
import org.hipparchus.random.CorrelatedRandomVectorGenerator;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.estimation.measurements.TurnAroundRange;
import org.orekit.estimation.measurements.generation.AbstractMeasurementBuilder;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.sampling.OrekitStepInterpolator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class TurnAroundRangeBuilder
extends AbstractMeasurementBuilder<TurnAroundRange> {
    private final GroundStation primaryStation;
    private final GroundStation secondaryStation;
    private final ObservableSatellite satellite;

    public TurnAroundRangeBuilder(CorrelatedRandomVectorGenerator noiseSource, GroundStation primaryStation, GroundStation secondaryStation, double sigma, double baseWeight, ObservableSatellite satellite) {
        super(noiseSource, sigma, baseWeight, satellite);
        this.primaryStation = primaryStation;
        this.secondaryStation = secondaryStation;
        this.satellite = satellite;
    }

    @Override
    public TurnAroundRange build(AbsoluteDate date, Map<ObservableSatellite, OrekitStepInterpolator> interpolators) {
        double sigma = this.getTheoreticalStandardDeviation()[0];
        double baseWeight = this.getBaseWeight()[0];
        SpacecraftState[] relevant = new SpacecraftState[]{interpolators.get(this.satellite).getInterpolatedState(date)};
        TurnAroundRange dummy = new TurnAroundRange(this.primaryStation, this.secondaryStation, relevant[0].getDate(), Double.NaN, sigma, baseWeight, this.satellite);
        for (EstimationModifier modifier : this.getModifiers()) {
            dummy.addModifier(modifier);
        }
        for (ParameterDriver driver : dummy.getParametersDrivers()) {
            AbsoluteDate end;
            if (driver.getReferenceDate() != null) continue;
            AbsoluteDate start = this.getStart();
            driver.setReferenceDate(start.durationFrom(end = this.getEnd()) <= 0.0 ? start : end);
        }
        double range = dummy.estimateWithoutDerivatives(relevant).getEstimatedValue()[0];
        double[] noise = this.getNoise();
        if (noise != null) {
            range += noise[0];
        }
        TurnAroundRange measurement = new TurnAroundRange(this.primaryStation, this.secondaryStation, relevant[0].getDate(), range, sigma, baseWeight, this.satellite);
        for (EstimationModifier modifier : this.getModifiers()) {
            measurement.addModifier(modifier);
        }
        return measurement;
    }
}

