/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.generation;

import java.util.Map;
import org.hipparchus.random.CorrelatedRandomVectorGenerator;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.estimation.measurements.RangeRate;
import org.orekit.estimation.measurements.generation.AbstractMeasurementBuilder;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.sampling.OrekitStepInterpolator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class RangeRateBuilder
extends AbstractMeasurementBuilder<RangeRate> {
    private final GroundStation station;
    private final boolean twoway;
    private final ObservableSatellite satellite;

    public RangeRateBuilder(CorrelatedRandomVectorGenerator noiseSource, GroundStation station, boolean twoWay, double sigma, double baseWeight, ObservableSatellite satellite) {
        super(noiseSource, sigma, baseWeight, satellite);
        this.station = station;
        this.twoway = twoWay;
        this.satellite = satellite;
    }

    @Override
    public RangeRate build(AbsoluteDate date, Map<ObservableSatellite, OrekitStepInterpolator> interpolators) {
        double sigma = this.getTheoreticalStandardDeviation()[0];
        double baseWeight = this.getBaseWeight()[0];
        SpacecraftState[] relevant = new SpacecraftState[]{interpolators.get(this.satellite).getInterpolatedState(date)};
        RangeRate dummy = new RangeRate(this.station, relevant[0].getDate(), Double.NaN, sigma, baseWeight, this.twoway, this.satellite);
        for (EstimationModifier modifier : this.getModifiers()) {
            dummy.addModifier(modifier);
        }
        for (ParameterDriver driver : dummy.getParametersDrivers()) {
            AbsoluteDate end;
            if (driver.getReferenceDate() != null) continue;
            AbsoluteDate start = this.getStart();
            driver.setReferenceDate(start.durationFrom(end = this.getEnd()) <= 0.0 ? start : end);
        }
        double rangeRate = dummy.estimateWithoutDerivatives(relevant).getEstimatedValue()[0];
        double[] noise = this.getNoise();
        if (noise != null) {
            rangeRate += noise[0];
        }
        RangeRate measurement = new RangeRate(this.station, relevant[0].getDate(), rangeRate, sigma, baseWeight, this.twoway, this.satellite);
        for (EstimationModifier modifier : this.getModifiers()) {
            measurement.addModifier(modifier);
        }
        return measurement;
    }
}

