/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.generation;

import java.util.Map;
import java.util.function.ToDoubleFunction;
import org.hipparchus.random.CorrelatedRandomVectorGenerator;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.estimation.measurements.generation.AbstractMeasurementBuilder;
import org.orekit.estimation.measurements.gnss.OneWayGNSSRange;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.sampling.OrekitStepInterpolator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.PVCoordinatesProvider;
import org.orekit.utils.ParameterDriver;

public class OneWayGNSSRangeBuilder
extends AbstractMeasurementBuilder<OneWayGNSSRange> {
    private final ObservableSatellite local;
    private final ObservableSatellite remote;
    private ToDoubleFunction<AbsoluteDate> remoteClockModel;

    public OneWayGNSSRangeBuilder(CorrelatedRandomVectorGenerator noiseSource, ObservableSatellite local, ObservableSatellite remote, ToDoubleFunction<AbsoluteDate> remoteClockModel, double sigma, double baseWeight) {
        super(noiseSource, sigma, baseWeight, local, remote);
        this.local = local;
        this.remote = remote;
        this.remoteClockModel = remoteClockModel;
    }

    @Override
    public OneWayGNSSRange build(AbsoluteDate date, Map<ObservableSatellite, OrekitStepInterpolator> interpolators) {
        double sigma = this.getTheoreticalStandardDeviation()[0];
        double baseWeight = this.getBaseWeight()[0];
        SpacecraftState[] relevant = new SpacecraftState[]{interpolators.get(this.local).getInterpolatedState(date), interpolators.get(this.remote).getInterpolatedState(date)};
        double offset = this.remoteClockModel.applyAsDouble(date);
        OneWayGNSSRange dummy = new OneWayGNSSRange((PVCoordinatesProvider)interpolators.get(this.remote), offset, date, Double.NaN, sigma, baseWeight, this.local);
        for (EstimationModifier modifier : this.getModifiers()) {
            dummy.addModifier(modifier);
        }
        for (ParameterDriver driver : dummy.getParametersDrivers()) {
            AbsoluteDate end;
            if (driver.getReferenceDate() != null) continue;
            AbsoluteDate start = this.getStart();
            driver.setReferenceDate(start.durationFrom(end = this.getEnd()) <= 0.0 ? start : end);
        }
        double range = dummy.estimateWithoutDerivatives(relevant).getEstimatedValue()[0];
        double[] noise = this.getNoise();
        if (noise != null) {
            range += noise[0];
        }
        OneWayGNSSRange measurement = new OneWayGNSSRange((PVCoordinatesProvider)interpolators.get(this.remote), offset, date, range, sigma, baseWeight, this.local);
        for (EstimationModifier modifier : this.getModifiers()) {
            measurement.addModifier(modifier);
        }
        return measurement;
    }
}

