/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.generation;

import java.util.Map;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import org.hipparchus.random.CorrelatedRandomVectorGenerator;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.estimation.measurements.QuadraticClockModel;
import org.orekit.estimation.measurements.generation.AbstractMeasurementBuilder;
import org.orekit.estimation.measurements.gnss.AmbiguityCache;
import org.orekit.estimation.measurements.gnss.OneWayGNSSPhase;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.sampling.OrekitStepInterpolator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class OneWayGNSSPhaseBuilder
extends AbstractMeasurementBuilder<OneWayGNSSPhase> {
    private final AmbiguityCache cache;
    private final double wavelength;
    private final ObservableSatellite local;
    private final ObservableSatellite remote;
    private final QuadraticClockModel remoteClockModel;
    @Deprecated
    private Function<AbsoluteDate, QuadraticClockModel> clockBuilder;

    @Deprecated
    public OneWayGNSSPhaseBuilder(CorrelatedRandomVectorGenerator noiseSource, ObservableSatellite local, ObservableSatellite remote, ToDoubleFunction<AbsoluteDate> remoteClockModel, double wavelength, double sigma, double baseWeight) {
        this(noiseSource, local, remote, null, wavelength, sigma, baseWeight, AmbiguityCache.DEFAULT_CACHE);
        this.clockBuilder = date -> {
            double cM = remoteClockModel.applyAsDouble(date.shiftedBy(-1.0));
            double c0 = remoteClockModel.applyAsDouble((AbsoluteDate)date);
            double cP = remoteClockModel.applyAsDouble(date.shiftedBy(1.0));
            return new QuadraticClockModel((AbsoluteDate)date, c0, 0.5 * (cP - cM), 0.5 * (cP + cM) - c0);
        };
    }

    public OneWayGNSSPhaseBuilder(CorrelatedRandomVectorGenerator noiseSource, ObservableSatellite local, ObservableSatellite remote, QuadraticClockModel remoteClockModel, double wavelength, double sigma, double baseWeight, AmbiguityCache cache) {
        super(noiseSource, sigma, baseWeight, local, remote);
        this.wavelength = wavelength;
        this.local = local;
        this.remote = remote;
        this.remoteClockModel = remoteClockModel;
        this.cache = cache;
    }

    @Override
    public OneWayGNSSPhase build(AbsoluteDate date, Map<ObservableSatellite, OrekitStepInterpolator> interpolators) {
        double sigma = this.getTheoreticalStandardDeviation()[0];
        double baseWeight = this.getBaseWeight()[0];
        SpacecraftState[] relevant = new SpacecraftState[]{interpolators.get(this.local).getInterpolatedState(date), interpolators.get(this.remote).getInterpolatedState(date)};
        QuadraticClockModel clockModel = this.remoteClockModel != null ? this.remoteClockModel : this.clockBuilder.apply(date);
        OneWayGNSSPhase dummy = new OneWayGNSSPhase(interpolators.get(this.remote), this.remote.getName(), clockModel, date, Double.NaN, this.wavelength, sigma, baseWeight, this.local, this.cache);
        for (EstimationModifier modifier : this.getModifiers()) {
            dummy.addModifier(modifier);
        }
        for (ParameterDriver driver : dummy.getParametersDrivers()) {
            AbsoluteDate end;
            if (driver.getReferenceDate() != null) continue;
            AbsoluteDate start = this.getStart();
            driver.setReferenceDate(start.durationFrom(end = this.getEnd()) <= 0.0 ? start : end);
        }
        double phase = dummy.estimateWithoutDerivatives(relevant).getEstimatedValue()[0];
        double[] noise = this.getNoise();
        if (noise != null) {
            phase += noise[0];
        }
        OneWayGNSSPhase measurement = new OneWayGNSSPhase(interpolators.get(this.remote), this.remote.getName(), clockModel, date, phase, this.wavelength, sigma, baseWeight, this.local, this.cache);
        for (EstimationModifier modifier : this.getModifiers()) {
            measurement.addModifier(modifier);
        }
        return measurement;
    }
}

