/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.generation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.MultiplexedMeasurement;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.estimation.measurements.generation.MeasurementBuilder;
import org.orekit.propagation.sampling.OrekitStepInterpolator;
import org.orekit.time.AbsoluteDate;

public class MultiplexedMeasurementBuilder
implements MeasurementBuilder<MultiplexedMeasurement> {
    private final List<MeasurementBuilder<?>> builders;
    private final ObservableSatellite[] satellites;
    private final List<EstimationModifier<MultiplexedMeasurement>> modifiers;

    public MultiplexedMeasurementBuilder(List<MeasurementBuilder<?>> builders) {
        this.builders = builders;
        this.modifiers = new ArrayList<EstimationModifier<MultiplexedMeasurement>>();
        ArrayList<ObservableSatellite> list = new ArrayList<ObservableSatellite>();
        for (MeasurementBuilder<?> builder : builders) {
            for (ObservableSatellite satellite : builder.getSatellites()) {
                if (list.contains(satellite)) continue;
                list.add(satellite);
            }
        }
        this.satellites = list.toArray(new ObservableSatellite[0]);
    }

    @Override
    public void init(AbsoluteDate start, AbsoluteDate end) {
        for (MeasurementBuilder<?> builder : this.builders) {
            builder.init(start, end);
        }
    }

    @Override
    public void addModifier(EstimationModifier<MultiplexedMeasurement> modifier) {
        this.modifiers.add(modifier);
    }

    @Override
    public List<EstimationModifier<MultiplexedMeasurement>> getModifiers() {
        return Collections.unmodifiableList(this.modifiers);
    }

    @Override
    public MultiplexedMeasurement build(AbsoluteDate date, Map<ObservableSatellite, OrekitStepInterpolator> interpolators) {
        ArrayList measurements = new ArrayList(this.builders.size());
        for (MeasurementBuilder<?> builder : this.builders) {
            measurements.add((ObservedMeasurement<?>)builder.build(date, interpolators));
        }
        MultiplexedMeasurement measurement = new MultiplexedMeasurement(measurements);
        for (EstimationModifier<MultiplexedMeasurement> modifier : this.getModifiers()) {
            measurement.addModifier(modifier);
        }
        return measurement;
    }

    @Override
    public ObservableSatellite[] getSatellites() {
        return (ObservableSatellite[])this.satellites.clone();
    }
}

