/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.generation;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.sampling.OrekitStepInterpolator;
import org.orekit.time.AbsoluteDate;

public interface MeasurementBuilder<T extends ObservedMeasurement<T>> {
    public void init(AbsoluteDate var1, AbsoluteDate var2);

    public void addModifier(EstimationModifier<T> var1);

    public List<EstimationModifier<T>> getModifiers();

    public ObservableSatellite[] getSatellites();

    public T build(AbsoluteDate var1, Map<ObservableSatellite, OrekitStepInterpolator> var2);

    default public T build(AbsoluteDate date, SpacecraftState[] states) {
        ConcurrentHashMap<ObservableSatellite, OrekitStepInterpolator> interpolators = new ConcurrentHashMap<ObservableSatellite, OrekitStepInterpolator>();
        for (int i = 0; i < states.length; ++i) {
            ObservableSatellite sat = this.getSatellites()[i];
            final SpacecraftState state = states[i];
            OrekitStepInterpolator interpolator = new OrekitStepInterpolator(){

                @Override
                public OrekitStepInterpolator restrictStep(SpacecraftState newPreviousState, SpacecraftState newCurrentState) {
                    return null;
                }

                @Override
                public boolean isPreviousStateInterpolated() {
                    return false;
                }

                @Override
                public boolean isForward() {
                    return true;
                }

                @Override
                public boolean isCurrentStateInterpolated() {
                    return false;
                }

                @Override
                public SpacecraftState getPreviousState() {
                    return state;
                }

                @Override
                public SpacecraftState getInterpolatedState(AbsoluteDate date) {
                    return state.shiftedBy(date.durationFrom(state));
                }

                @Override
                public SpacecraftState getCurrentState() {
                    return state;
                }
            };
            interpolators.put(sat, interpolator);
        }
        return this.build(date, interpolators);
    }
}

