/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.generation;

import java.util.Map;
import org.hipparchus.random.CorrelatedRandomVectorGenerator;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.InterSatellitesRange;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.estimation.measurements.generation.AbstractMeasurementBuilder;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.sampling.OrekitStepInterpolator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class InterSatellitesRangeBuilder
extends AbstractMeasurementBuilder<InterSatellitesRange> {
    private final boolean twoway;
    private final ObservableSatellite local;
    private final ObservableSatellite remote;

    public InterSatellitesRangeBuilder(CorrelatedRandomVectorGenerator noiseSource, ObservableSatellite local, ObservableSatellite remote, boolean twoWay, double sigma, double baseWeight) {
        super(noiseSource, sigma, baseWeight, local, remote);
        this.twoway = twoWay;
        this.local = local;
        this.remote = remote;
    }

    @Override
    public InterSatellitesRange build(AbsoluteDate date, Map<ObservableSatellite, OrekitStepInterpolator> interpolators) {
        double sigma = this.getTheoreticalStandardDeviation()[0];
        double baseWeight = this.getBaseWeight()[0];
        SpacecraftState[] relevant = new SpacecraftState[]{interpolators.get(this.local).getInterpolatedState(date), interpolators.get(this.remote).getInterpolatedState(date)};
        InterSatellitesRange dummy = new InterSatellitesRange(this.local, this.remote, this.twoway, relevant[0].getDate(), Double.NaN, sigma, baseWeight);
        for (EstimationModifier modifier : this.getModifiers()) {
            dummy.addModifier(modifier);
        }
        for (ParameterDriver driver : dummy.getParametersDrivers()) {
            AbsoluteDate end;
            if (driver.getReferenceDate() != null) continue;
            AbsoluteDate start = this.getStart();
            driver.setReferenceDate(start.durationFrom(end = this.getEnd()) <= 0.0 ? start : end);
        }
        double range = dummy.estimateWithoutDerivatives(relevant).getEstimatedValue()[0];
        double[] noise = this.getNoise();
        if (noise != null) {
            range += noise[0];
        }
        InterSatellitesRange measurement = new InterSatellitesRange(this.local, this.remote, this.twoway, relevant[0].getDate(), range, sigma, baseWeight);
        for (EstimationModifier modifier : this.getModifiers()) {
            measurement.addModifier(modifier);
        }
        return measurement;
    }
}

