/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.generation;

import java.util.Map;
import org.hipparchus.random.CorrelatedRandomVectorGenerator;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.estimation.measurements.generation.AbstractMeasurementBuilder;
import org.orekit.estimation.measurements.gnss.AmbiguityCache;
import org.orekit.estimation.measurements.gnss.InterSatellitesPhase;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.sampling.OrekitStepInterpolator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class InterSatellitesPhaseBuilder
extends AbstractMeasurementBuilder<InterSatellitesPhase> {
    private final AmbiguityCache cache;
    private final double wavelength;
    private final ObservableSatellite local;
    private final ObservableSatellite remote;

    @Deprecated
    public InterSatellitesPhaseBuilder(CorrelatedRandomVectorGenerator noiseSource, ObservableSatellite local, ObservableSatellite remote, double wavelength, double sigma, double baseWeight) {
        this(noiseSource, local, remote, wavelength, sigma, baseWeight, AmbiguityCache.DEFAULT_CACHE);
    }

    public InterSatellitesPhaseBuilder(CorrelatedRandomVectorGenerator noiseSource, ObservableSatellite local, ObservableSatellite remote, double wavelength, double sigma, double baseWeight, AmbiguityCache cache) {
        super(noiseSource, sigma, baseWeight, local, remote);
        this.cache = cache;
        this.wavelength = wavelength;
        this.local = local;
        this.remote = remote;
    }

    @Override
    public InterSatellitesPhase build(AbsoluteDate date, Map<ObservableSatellite, OrekitStepInterpolator> interpolators) {
        double sigma = this.getTheoreticalStandardDeviation()[0];
        double baseWeight = this.getBaseWeight()[0];
        SpacecraftState[] relevant = new SpacecraftState[]{interpolators.get(this.local).getInterpolatedState(date), interpolators.get(this.remote).getInterpolatedState(date)};
        InterSatellitesPhase dummy = new InterSatellitesPhase(this.local, this.remote, relevant[0].getDate(), Double.NaN, this.wavelength, sigma, baseWeight, this.cache);
        for (EstimationModifier modifier : this.getModifiers()) {
            dummy.addModifier(modifier);
        }
        for (ParameterDriver driver : dummy.getParametersDrivers()) {
            AbsoluteDate end;
            if (driver.getReferenceDate() != null) continue;
            AbsoluteDate start = this.getStart();
            driver.setReferenceDate(start.durationFrom(end = this.getEnd()) <= 0.0 ? start : end);
        }
        double phase = dummy.estimateWithoutDerivatives(relevant).getEstimatedValue()[0];
        double[] noise = this.getNoise();
        if (noise != null) {
            phase += noise[0];
        }
        InterSatellitesPhase measurement = new InterSatellitesPhase(this.local, this.remote, relevant[0].getDate(), phase, this.wavelength, sigma, baseWeight, this.cache);
        for (EstimationModifier modifier : this.getModifiers()) {
            measurement.addModifier(modifier);
        }
        return measurement;
    }
}

