/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.generation;

import java.util.Map;
import org.hipparchus.random.CorrelatedRandomVectorGenerator;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.estimation.measurements.generation.AbstractMeasurementBuilder;
import org.orekit.estimation.measurements.gnss.InterSatellitesOneWayRangeRate;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.sampling.OrekitStepInterpolator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class InterSatellitesOneWayRangeRateBuilder
extends AbstractMeasurementBuilder<InterSatellitesOneWayRangeRate> {
    private final ObservableSatellite local;
    private final ObservableSatellite remote;

    public InterSatellitesOneWayRangeRateBuilder(CorrelatedRandomVectorGenerator noiseSource, ObservableSatellite local, ObservableSatellite remote, double sigma, double baseWeight) {
        super(noiseSource, sigma, baseWeight, local, remote);
        this.local = local;
        this.remote = remote;
    }

    @Override
    public InterSatellitesOneWayRangeRate build(AbsoluteDate date, Map<ObservableSatellite, OrekitStepInterpolator> interpolators) {
        double sigma = this.getTheoreticalStandardDeviation()[0];
        double baseWeight = this.getBaseWeight()[0];
        SpacecraftState[] relevant = new SpacecraftState[]{interpolators.get(this.local).getInterpolatedState(date), interpolators.get(this.remote).getInterpolatedState(date)};
        InterSatellitesOneWayRangeRate dummy = new InterSatellitesOneWayRangeRate(this.local, this.remote, relevant[0].getDate(), Double.NaN, sigma, baseWeight);
        for (EstimationModifier modifier : this.getModifiers()) {
            dummy.addModifier(modifier);
        }
        for (ParameterDriver driver : dummy.getParametersDrivers()) {
            AbsoluteDate end;
            if (driver.getReferenceDate() != null) continue;
            AbsoluteDate start = this.getStart();
            driver.setReferenceDate(start.durationFrom(end = this.getEnd()) <= 0.0 ? start : end);
        }
        double rangeRate = dummy.estimateWithoutDerivatives(relevant).getEstimatedValue()[0];
        double[] noise = this.getNoise();
        if (noise != null) {
            rangeRate += noise[0];
        }
        InterSatellitesOneWayRangeRate measurement = new InterSatellitesOneWayRangeRate(this.local, this.remote, relevant[0].getDate(), rangeRate, sigma, baseWeight);
        for (EstimationModifier modifier : this.getModifiers()) {
            measurement.addModifier(modifier);
        }
        return measurement;
    }
}

