/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.generation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.estimation.measurements.generation.GeneratedMeasurementSubscriber;
import org.orekit.estimation.measurements.generation.Scheduler;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.PropagatorsParallelizer;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.sampling.MultiSatStepHandler;
import org.orekit.propagation.sampling.OrekitStepHandler;
import org.orekit.propagation.sampling.OrekitStepInterpolator;
import org.orekit.propagation.sampling.StepHandlerMultiplexer;
import org.orekit.time.AbsoluteDate;

public class Generator {
    private final List<ObservableSatellite> observableSatellites = new ArrayList<ObservableSatellite>();
    private final List<Propagator> propagators = new ArrayList<Propagator>();
    private final List<Scheduler<? extends ObservedMeasurement<?>>> multiSatSchedulers = new ArrayList();
    private final Map<ObservableSatellite, List<Scheduler<? extends ObservedMeasurement<?>>>> singleSatSchedulers = new HashMap();
    private final List<GeneratedMeasurementSubscriber> subscribers = new ArrayList<GeneratedMeasurementSubscriber>();

    public ObservableSatellite addPropagator(Propagator propagator) {
        ObservableSatellite os = new ObservableSatellite(this.propagators.size());
        this.observableSatellites.add(os);
        this.propagators.add(propagator);
        return os;
    }

    public Propagator getPropagator(ObservableSatellite satellite) {
        return this.propagators.get(satellite.getPropagatorIndex());
    }

    public <T extends ObservedMeasurement<T>> void addScheduler(Scheduler<T> scheduler) {
        ObservableSatellite[] satellites = scheduler.getBuilder().getSatellites();
        if (satellites.length == 1) {
            List<Scheduler<ObservedMeasurement<?>>> list = this.singleSatSchedulers.get(satellites[0]);
            if (list == null) {
                list = new ArrayList();
                this.singleSatSchedulers.put(satellites[0], list);
            }
            list.add(scheduler);
        } else {
            this.multiSatSchedulers.add(scheduler);
        }
    }

    public void addSubscriber(GeneratedMeasurementSubscriber subscriber) {
        this.subscribers.add(subscriber);
    }

    public void generate(AbsoluteDate start, AbsoluteDate end) {
        MultipleSatGeneratorHandler globalHandler = new MultipleSatGeneratorHandler(this.multiSatSchedulers, this.subscribers, this.observableSatellites, end.isAfterOrEqualTo(start));
        for (Map.Entry<ObservableSatellite, List<Scheduler<ObservedMeasurement<?>>>> entry : this.singleSatSchedulers.entrySet()) {
            StepHandlerMultiplexer multiplexer = this.propagators.get(entry.getKey().getPropagatorIndex()).getMultiplexer();
            for (Scheduler<? extends ObservedMeasurement<?>> scheduler : entry.getValue()) {
                multiplexer.add(new SingleSatGeneratorHandler(scheduler, globalHandler));
            }
        }
        PropagatorsParallelizer parallelizer = new PropagatorsParallelizer(this.propagators, globalHandler);
        parallelizer.propagate(start, end);
        for (Map.Entry<ObservableSatellite, List<Scheduler<ObservedMeasurement<?>>>> entry : this.singleSatSchedulers.entrySet()) {
            StepHandlerMultiplexer multiplexer = this.propagators.get(entry.getKey().getPropagatorIndex()).getMultiplexer();
            ArrayList<OrekitStepHandler> arrayList = new ArrayList<OrekitStepHandler>();
            for (OrekitStepHandler handler : multiplexer.getHandlers()) {
                if (!(handler instanceof SingleSatGeneratorHandler) || ((SingleSatGeneratorHandler)handler).globalHandler != globalHandler) continue;
                arrayList.add(handler);
            }
            for (OrekitStepHandler handler : arrayList) {
                multiplexer.remove(handler);
            }
        }
    }

    private static class MultipleSatGeneratorHandler
    implements MultiSatStepHandler {
        private final List<Scheduler<? extends ObservedMeasurement<?>>> schedulers;
        private final List<GeneratedMeasurementSubscriber> subscribers;
        private final List<ObservableSatellite> observableSatellites;
        private final SortedSet<ObservedMeasurement<?>> generated;
        private final boolean forward;

        MultipleSatGeneratorHandler(List<Scheduler<? extends ObservedMeasurement<?>>> schedulers, List<GeneratedMeasurementSubscriber> subscribers, List<ObservableSatellite> observableSatellites, boolean forward) {
            Comparator comparator = forward ? Comparator.naturalOrder() : Comparator.reverseOrder();
            this.schedulers = schedulers;
            this.subscribers = subscribers;
            this.observableSatellites = observableSatellites;
            this.generated = new TreeSet(comparator);
            this.forward = forward;
        }

        @Override
        public void init(List<SpacecraftState> states0, AbsoluteDate t) {
            AbsoluteDate start = states0.get(0).getDate();
            for (Scheduler<ObservedMeasurement<?>> scheduler : this.schedulers) {
                scheduler.init(start, t);
            }
            for (GeneratedMeasurementSubscriber subscriber : this.subscribers) {
                subscriber.init(start, t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleStep(List<OrekitStepInterpolator> interpolators) {
            HashMap<ObservableSatellite, OrekitStepInterpolator> interpolatorsMap = new HashMap<ObservableSatellite, OrekitStepInterpolator>(interpolators.size());
            for (int i = 0; i < interpolators.size(); ++i) {
                interpolatorsMap.put(this.observableSatellites.get(i), interpolators.get(i));
            }
            AbsoluteDate lastDate = interpolators.get(0).getCurrentState().getDate();
            SortedSet<ObservedMeasurement<?>> sortedSet = this.generated;
            synchronized (sortedSet) {
                ObservedMeasurement measurement;
                for (Scheduler<ObservedMeasurement<?>> scheduler : this.schedulers) {
                    this.generated.addAll(scheduler.generate(interpolatorsMap));
                }
                Iterator iterator = this.generated.iterator();
                while (iterator.hasNext() && this.forward == lastDate.isAfterOrEqualTo(measurement = (ObservedMeasurement)iterator.next())) {
                    for (GeneratedMeasurementSubscriber subscriber : this.subscribers) {
                        subscriber.handleGeneratedMeasurement(measurement);
                    }
                    iterator.remove();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finish(List<SpacecraftState> finalStates) {
            SortedSet<ObservedMeasurement<?>> sortedSet = this.generated;
            synchronized (sortedSet) {
                for (ObservedMeasurement observedMeasurement : this.generated) {
                    for (GeneratedMeasurementSubscriber subscriber : this.subscribers) {
                        subscriber.handleGeneratedMeasurement(observedMeasurement);
                    }
                }
                this.generated.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addMeasurements(SortedSet<? extends ObservedMeasurement<?>> measurements) {
            SortedSet<ObservedMeasurement<?>> sortedSet = this.generated;
            synchronized (sortedSet) {
                this.generated.addAll(measurements);
            }
        }
    }

    private static class SingleSatGeneratorHandler<T extends ObservedMeasurement<T>>
    implements OrekitStepHandler {
        private final Scheduler<T> scheduler;
        private final ObservableSatellite satellite;
        private final MultipleSatGeneratorHandler globalHandler;

        SingleSatGeneratorHandler(Scheduler<T> scheduler, MultipleSatGeneratorHandler globalHandler) {
            this.scheduler = scheduler;
            this.satellite = scheduler.getBuilder().getSatellites()[0];
            this.globalHandler = globalHandler;
        }

        @Override
        public void init(SpacecraftState state0, AbsoluteDate t) {
            this.scheduler.init(state0.getDate(), t);
        }

        @Override
        public void handleStep(OrekitStepInterpolator interpolator) {
            this.globalHandler.addMeasurements(this.scheduler.generate(Collections.singletonMap(this.satellite, interpolator)));
        }
    }
}

