/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.generation;

import java.util.Collections;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.estimation.measurements.generation.GeneratedMeasurementSubscriber;
import org.orekit.time.AbsoluteDate;

public class GatheringSubscriber
implements GeneratedMeasurementSubscriber {
    private SortedSet<ObservedMeasurement<?>> measurements = Collections.emptySortedSet();

    @Override
    public void init(AbsoluteDate start, AbsoluteDate end) {
        Comparator comparator = end.isAfterOrEqualTo(start) ? Comparator.naturalOrder() : Comparator.reverseOrder();
        this.measurements = new TreeSet(comparator);
    }

    @Override
    public void handleGeneratedMeasurement(ObservedMeasurement<?> measurement) {
        this.measurements.add(measurement);
    }

    public SortedSet<ObservedMeasurement<?>> getGeneratedMeasurements() {
        return Collections.unmodifiableSortedSet(this.measurements);
    }
}

