/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.generation;

import java.util.Map;
import org.hipparchus.random.CorrelatedRandomVectorGenerator;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.FDOA;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.estimation.measurements.generation.AbstractMeasurementBuilder;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.sampling.OrekitStepInterpolator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class FDOABuilder
extends AbstractMeasurementBuilder<FDOA> {
    private final GroundStation primeStation;
    private final GroundStation secondStation;
    private final double centreFrequency;
    private final ObservableSatellite satellite;

    public FDOABuilder(CorrelatedRandomVectorGenerator noiseSource, GroundStation primeStation, GroundStation secondStation, double centreFrequency, double sigma, double baseWeight, ObservableSatellite satellite) {
        super(noiseSource, sigma, baseWeight, satellite);
        this.primeStation = primeStation;
        this.secondStation = secondStation;
        this.centreFrequency = centreFrequency;
        this.satellite = satellite;
    }

    @Override
    public FDOA build(AbsoluteDate date, Map<ObservableSatellite, OrekitStepInterpolator> interpolators) {
        double sigma = this.getTheoreticalStandardDeviation()[0];
        double baseWeight = this.getBaseWeight()[0];
        SpacecraftState[] relevant = new SpacecraftState[]{interpolators.get(this.satellite).getInterpolatedState(date)};
        FDOA dummy = new FDOA(this.primeStation, this.secondStation, this.centreFrequency, relevant[0].getDate(), Double.NaN, sigma, baseWeight, this.satellite);
        for (EstimationModifier modifier : this.getModifiers()) {
            dummy.addModifier(modifier);
        }
        for (ParameterDriver driver : dummy.getParametersDrivers()) {
            AbsoluteDate end;
            if (driver.getReferenceDate() != null) continue;
            AbsoluteDate start = this.getStart();
            driver.setReferenceDate(start.durationFrom(end = this.getEnd()) <= 0.0 ? start : end);
        }
        double fdoa = dummy.estimateWithoutDerivatives(relevant).getEstimatedValue()[0];
        double[] noise = this.getNoise();
        if (noise != null) {
            fdoa += noise[0];
        }
        FDOA measurement = new FDOA(this.primeStation, this.secondStation, this.centreFrequency, relevant[0].getDate(), fdoa, sigma, baseWeight, this.satellite);
        for (EstimationModifier modifier : this.getModifiers()) {
            measurement.addModifier(modifier);
        }
        return measurement;
    }
}

