/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.generation;

import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.estimation.measurements.generation.AbstractScheduler;
import org.orekit.estimation.measurements.generation.MeasurementBuilder;
import org.orekit.estimation.measurements.generation.SignSemantic;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.events.AdapterDetector;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DatesSelector;
import org.orekit.utils.TimeSpanMap;

public class EventBasedScheduler<T extends ObservedMeasurement<T>>
extends AbstractScheduler<T> {
    private final SignSemantic signSemantic;
    private TimeSpanMap<Boolean> feasibility;
    private boolean forward;

    public EventBasedScheduler(MeasurementBuilder<T> builder, DatesSelector selector, Propagator propagator, EventDetector detector, SignSemantic signSemantic) {
        super(builder, selector);
        this.signSemantic = signSemantic;
        this.feasibility = new TimeSpanMap<Boolean>(Boolean.FALSE);
        this.forward = true;
        propagator.addEventDetector(new FeasibilityAdapter(detector));
    }

    @Override
    public boolean measurementIsFeasible(AbsoluteDate date) {
        return this.feasibility.get(date);
    }

    private class FeasibilityAdapter
    extends AdapterDetector {
        FeasibilityAdapter(EventDetector detector) {
            super(detector);
        }

        @Override
        public void init(SpacecraftState s0, AbsoluteDate t) {
            super.init(s0, t);
            EventBasedScheduler.this.forward = t.compareTo(s0.getDate()) > 0;
            EventBasedScheduler.this.feasibility = new TimeSpanMap<Boolean>(EventBasedScheduler.this.signSemantic.measurementIsFeasible(this.g(s0)));
        }

        @Override
        public EventHandler getHandler() {
            EventDetector rawDetector = this.getDetector();
            EventHandler rawHandler = rawDetector.getHandler();
            return (state, detector, increasing) -> {
                boolean statusAfter = EventBasedScheduler.this.signSemantic.measurementIsFeasible(increasing ? 1.0 : -1.0);
                if (EventBasedScheduler.this.forward) {
                    EventBasedScheduler.this.feasibility.addValidAfter(statusAfter, state.getDate(), false);
                } else {
                    EventBasedScheduler.this.feasibility.addValidBefore(!statusAfter, state.getDate(), false);
                }
                return rawHandler.eventOccurred(state, rawDetector, increasing);
            };
        }
    }
}

