/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.generation;

import java.util.Map;
import org.hipparchus.random.CorrelatedRandomVectorGenerator;
import org.orekit.estimation.measurements.AngularRaDec;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.GroundStation;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.estimation.measurements.generation.AbstractMeasurementBuilder;
import org.orekit.frames.Frame;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.sampling.OrekitStepInterpolator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.ParameterDriver;

public class AngularRaDecBuilder
extends AbstractMeasurementBuilder<AngularRaDec> {
    private final GroundStation station;
    private final Frame referenceFrame;
    private final ObservableSatellite satellite;

    public AngularRaDecBuilder(CorrelatedRandomVectorGenerator noiseSource, GroundStation station, Frame referenceFrame, double[] sigma, double[] baseWeight, ObservableSatellite satellite) {
        super(noiseSource, sigma, baseWeight, satellite);
        this.station = station;
        this.referenceFrame = referenceFrame;
        this.satellite = satellite;
    }

    @Override
    public AngularRaDec build(AbsoluteDate date, Map<ObservableSatellite, OrekitStepInterpolator> interpolators) {
        double[] sigma = this.getTheoreticalStandardDeviation();
        double[] baseWeight = this.getBaseWeight();
        SpacecraftState[] relevant = new SpacecraftState[]{interpolators.get(this.satellite).getInterpolatedState(date)};
        AngularRaDec dummy = new AngularRaDec(this.station, this.referenceFrame, relevant[0].getDate(), new double[]{0.0, 0.0}, sigma, baseWeight, this.satellite);
        for (EstimationModifier modifier : this.getModifiers()) {
            dummy.addModifier(modifier);
        }
        for (ParameterDriver driver : dummy.getParametersDrivers()) {
            AbsoluteDate end;
            if (driver.getReferenceDate() != null) continue;
            AbsoluteDate start = this.getStart();
            driver.setReferenceDate(start.durationFrom(end = this.getEnd()) <= 0.0 ? start : end);
        }
        double[] angular = dummy.estimateWithoutDerivatives(relevant).getEstimatedValue();
        double[] noise = this.getNoise();
        if (noise != null) {
            angular[0] = angular[0] + noise[0];
            angular[1] = angular[1] + noise[1];
        }
        AngularRaDec measurement = new AngularRaDec(this.station, this.referenceFrame, relevant[0].getDate(), angular, sigma, baseWeight, this.satellite);
        for (EstimationModifier modifier : this.getModifiers()) {
            measurement.addModifier(modifier);
        }
        return measurement;
    }
}

