/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.generation;

import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.estimation.measurements.generation.MeasurementBuilder;
import org.orekit.estimation.measurements.generation.Scheduler;
import org.orekit.propagation.sampling.OrekitStepInterpolator;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.DatesSelector;

public abstract class AbstractScheduler<T extends ObservedMeasurement<T>>
implements Scheduler<T> {
    private final MeasurementBuilder<T> builder;
    private final DatesSelector selector;

    protected AbstractScheduler(MeasurementBuilder<T> builder, DatesSelector selector) {
        this.builder = builder;
        this.selector = selector;
    }

    @Override
    public void init(AbsoluteDate start, AbsoluteDate end) {
        this.builder.init(start, end);
    }

    @Override
    public MeasurementBuilder<T> getBuilder() {
        return this.builder;
    }

    public DatesSelector getSelector() {
        return this.selector;
    }

    @Override
    public SortedSet<T> generate(Map<ObservableSatellite, OrekitStepInterpolator> interpolators) {
        Map.Entry<ObservableSatellite, OrekitStepInterpolator> first = interpolators.entrySet().iterator().next();
        List<AbsoluteDate> dates = this.getSelector().selectDates(first.getValue().getPreviousState().getDate(), first.getValue().getCurrentState().getDate());
        TreeSet<T> measurements = new TreeSet<T>();
        for (AbsoluteDate date : dates) {
            if (!this.measurementIsFeasible(date)) continue;
            measurements.add(this.getBuilder().build(date, interpolators));
        }
        return measurements;
    }

    protected abstract boolean measurementIsFeasible(AbsoluteDate var1);
}

