/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.generation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hipparchus.random.CorrelatedRandomVectorGenerator;
import org.orekit.estimation.measurements.EstimationModifier;
import org.orekit.estimation.measurements.ObservableSatellite;
import org.orekit.estimation.measurements.ObservedMeasurement;
import org.orekit.estimation.measurements.generation.MeasurementBuilder;
import org.orekit.time.AbsoluteDate;

public abstract class AbstractMeasurementBuilder<T extends ObservedMeasurement<T>>
implements MeasurementBuilder<T> {
    private final CorrelatedRandomVectorGenerator noiseSource;
    private final List<EstimationModifier<T>> modifiers;
    private final double[] sigma;
    private final double[] baseWeight;
    private final ObservableSatellite[] satellites;
    private AbsoluteDate spanStart;
    private AbsoluteDate spanEnd;

    protected AbstractMeasurementBuilder(CorrelatedRandomVectorGenerator noiseSource, double sigma, double baseWeight, ObservableSatellite ... satellites) {
        this(noiseSource, new double[]{sigma}, new double[]{baseWeight}, satellites);
    }

    protected AbstractMeasurementBuilder(CorrelatedRandomVectorGenerator noiseSource, double[] sigma, double[] baseWeight, ObservableSatellite ... satellites) {
        this.noiseSource = noiseSource;
        this.modifiers = new ArrayList<EstimationModifier<T>>();
        this.sigma = (double[])sigma.clone();
        this.baseWeight = (double[])baseWeight.clone();
        this.satellites = (ObservableSatellite[])satellites.clone();
    }

    @Override
    public void init(AbsoluteDate start, AbsoluteDate end) {
        this.spanStart = start;
        this.spanEnd = end;
    }

    @Override
    public void addModifier(EstimationModifier<T> modifier) {
        this.modifiers.add(modifier);
    }

    @Override
    public List<EstimationModifier<T>> getModifiers() {
        return Collections.unmodifiableList(this.modifiers);
    }

    protected AbsoluteDate getStart() {
        return this.spanStart;
    }

    protected AbsoluteDate getEnd() {
        return this.spanEnd;
    }

    protected double[] getNoise() {
        return this.noiseSource == null ? null : this.noiseSource.nextVector();
    }

    protected double[] getTheoreticalStandardDeviation() {
        return (double[])this.sigma.clone();
    }

    protected double[] getBaseWeight() {
        return (double[])this.baseWeight.clone();
    }

    @Override
    public ObservableSatellite[] getSatellites() {
        return (ObservableSatellite[])this.satellites.clone();
    }
}

