/*
 * Decompiled with CFR 0.152.
 */
package org.orekit.estimation.measurements.filtering;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.orekit.estimation.measurements.filtering.SingleFrequencyHatchFilter;
import org.orekit.estimation.measurements.filtering.SmoothedObservationDataSet;
import org.orekit.files.rinex.observation.ObservationData;
import org.orekit.files.rinex.observation.ObservationDataSet;
import org.orekit.gnss.MeasurementType;
import org.orekit.gnss.ObservationType;
import org.orekit.gnss.SatelliteSystem;
import org.orekit.time.ChronologicalComparator;

public class SingleFrequencySmoother {
    private int N;
    private double integrationTime;
    private double threshold;
    private MeasurementType type;
    private HashMap<ObservationType, SingleFrequencyHatchFilter> mapFilters;
    private HashMap<ObservationType, List<SmoothedObservationDataSet>> mapFilteredData = new HashMap();

    public SingleFrequencySmoother(MeasurementType type, double threshold, int N, double integrationTime) {
        this.mapFilters = new HashMap();
        this.type = type;
        this.N = N;
        this.integrationTime = integrationTime;
        this.threshold = threshold;
    }

    public SingleFrequencyHatchFilter createFilter(ObservationData codeData, ObservationData smoothingData, SatelliteSystem system) {
        double wavelength = smoothingData.getObservationType().getFrequency(system).getWavelength();
        return new SingleFrequencyHatchFilter(codeData, smoothingData, this.type, wavelength, this.threshold, this.N, this.integrationTime);
    }

    public HashMap<ObservationType, List<SmoothedObservationDataSet>> getFilteredDataMap() {
        return this.mapFilteredData;
    }

    public final HashMap<ObservationType, SingleFrequencyHatchFilter> getMapFilters() {
        return this.mapFilters;
    }

    public ObservationData copyObservationData(ObservationData obsData) {
        return new ObservationData(obsData.getObservationType(), obsData.getValue(), obsData.getLossOfLockIndicator(), obsData.getSignalStrength());
    }

    public void filterDataSet(List<ObservationDataSet> listODS, SatelliteSystem satSystem, int prnNumber, ObservationType obsType) {
        ArrayList<ObservationDataSet> sortedListODS = new ArrayList<ObservationDataSet>(listODS);
        sortedListODS.sort(new ChronologicalComparator());
        for (ObservationDataSet obsSet : sortedListODS) {
            if (obsSet.getSatellite().getSystem() != satSystem || obsSet.getSatellite().getPRN() != prnNumber) continue;
            List<ObservationData> listObsData = obsSet.getObservationData();
            for (ObservationData obsData : listObsData) {
                ObservationType obsTypeData;
                double snr = obsData.getSignalStrength();
                if (Double.isNaN(obsData.getValue()) || snr != 0.0 && !(snr >= 4.0) || (obsTypeData = obsData.getObservationType()).getMeasurementType() != MeasurementType.PSEUDO_RANGE) continue;
                ObservationData obsDataSmoothing = null;
                for (ObservationData obsDataSmoothingCurr : listObsData) {
                    ObservationType obsTypeSmoothingCurr = obsDataSmoothingCurr.getObservationType();
                    if (Double.isNaN(obsDataSmoothingCurr.getValue()) || obsTypeSmoothingCurr != obsType) continue;
                    obsDataSmoothing = this.copyObservationData(obsDataSmoothingCurr);
                }
                SingleFrequencyHatchFilter filterObject = this.mapFilters.get((Object)obsTypeData);
                if (filterObject == null && obsDataSmoothing != null) {
                    filterObject = this.createFilter(obsData, obsDataSmoothing, satSystem);
                    this.mapFilters.put(obsTypeData, filterObject);
                    ArrayList<SmoothedObservationDataSet> odList = new ArrayList<SmoothedObservationDataSet>();
                    odList.add(new SmoothedObservationDataSet(obsData, obsSet));
                    this.mapFilteredData.put(obsTypeData, odList);
                    continue;
                }
                if (filterObject == null) continue;
                if (obsDataSmoothing == null) {
                    filterObject.resetFilterNext(obsData.getValue());
                    continue;
                }
                ObservationData filteredRange = filterObject.filterData(obsData, obsDataSmoothing);
                this.mapFilteredData.get((Object)obsTypeData).add(new SmoothedObservationDataSet(filteredRange, obsSet));
            }
        }
    }
}

